/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BusoshokuHakiFullBodyHardeningAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "busoshoku_haki_full_body_hardening", new Pair[]{ImmutablePair.of((Object)"Covers the whole body of the user user in a layer of Armament haki, used for a balance between offense and defense.", null)});
    public static final AbilityCore<BusoshokuHakiFullBodyHardeningAbility> INSTANCE = new AbilityCore.Builder<BusoshokuHakiFullBodyHardeningAbility>("Busoshoku Haki: Full Body Hardening", AbilityCategory.HAKI, BusoshokuHakiFullBodyHardeningAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(BusoshokuHakiFullBodyHardeningAbility::canUnlock).setSourceType(SourceType.FIST).build();
    public static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.BUSOSHOKU_HAKI_ARM).setColor(WyHelper.hexToRGB("#FFFFFFAA")).build();
    private Predicate<LivingEntity> emptyHandPredicate;
    private static final UUID ARMOR_UUID = UUID.fromString("0457f786-0a5a-4e83-9ea6-f924c259a798");
    private static final UUID ARMOR_THOUGNESS_UUID = UUID.fromString("0457f786-0a5a-4e83-9ea6-f924c259a798");
    private static final UUID TOUGHNESS_UUID = UUID.fromString("9121ac66-fb1c-48a7-a636-0cdc3f01d96e");
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::continuousStartEvent).addEndEvent(this::continuousStopEvent).addTickEvent(this::continuousTickEvent);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(100, this::onHitEvent);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.SIMPLE_BUSOSHOKU_HAKI, new AbilityPool2[0]);

    public BusoshokuHakiFullBodyHardeningAbility(AbilityCore<BusoshokuHakiFullBodyHardeningAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.statsComponent, this.hitTriggerComponent, this.skinOverlayComponent, this.poolComponent);
        super.addCanUseCheck(HakiHelper::canEnableHaki);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.emptyHandPredicate == null) {
            this.emptyHandPredicate = e -> this.continuousComponent.isContinuous() && e.func_184614_ca().func_190926_b();
        }
        IHakiData hakiProps = HakiDataCapability.get(entity);
        double defense = hakiProps.getBusoshokuHakiExp() / 12.5f;
        this.statsComponent.addAttributeModifier(Attributes.field_233826_i_, (AttributeModifier)this.getArmorMod(defense), e -> this.continuousComponent.isContinuous());
        this.statsComponent.addAttributeModifier(Attributes.field_233827_j_, (AttributeModifier)this.getArmorThougnessMod(defense / 4.0), e -> this.continuousComponent.isContinuous());
        this.statsComponent.addAttributeModifier((Attribute)ModAttributes.TOUGHNESS.get(), (AttributeModifier)this.getToughnessMod(8.0f * (hakiProps.getBusoshokuHakiExp() / (float)CommonConfig.INSTANCE.getHakiExpLimit())), e -> this.continuousComponent.isContinuous());
        this.continuousComponent.triggerContinuity(entity);
    }

    private void continuousStartEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BUSOSHOKU_HAKI_SFX.get(), SoundCategory.PLAYERS, 2.0f, 0.8f);
        this.skinOverlayComponent.showAll(entity);
    }

    private void continuousStopEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    private void continuousTickEvent(LivingEntity entity, IAbility ability) {
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(entity, 0);
        if (isOnMaxOveruse) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private HitTriggerComponent.HitResult onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            source.bypassLogia();
            return HitTriggerComponent.HitResult.HIT;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private AbilityAttributeModifier getArmorMod(double amount) {
        return new AbilityAttributeModifier(ARMOR_UUID, INSTANCE, "Full Body Haki Armor Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    private AbilityAttributeModifier getArmorThougnessMod(double amount) {
        return new AbilityAttributeModifier(ARMOR_THOUGNESS_UUID, INSTANCE, "Full Body Haki Armor Toughness Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    private AbilityAttributeModifier getToughnessMod(double amount) {
        return new AbilityAttributeModifier(TOUGHNESS_UUID, INSTANCE, "Full Body Haki Toughness Modifier", amount, AttributeModifier.Operation.ADDITION);
    }

    private static boolean canUnlock(LivingEntity user) {
        IAbilityData abilityProps = AbilityDataCapability.get(user);
        IHakiData props = HakiDataCapability.get(user);
        IEntityStats statsProps = EntityStatsCapability.get(user);
        boolean hasHardeningUnlocked = abilityProps.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
        return hasHardeningUnlocked && statsProps.getDoriki() > 5000.0 && (double)props.getBusoshokuHakiExp() > HakiHelper.getBusoshokuFullBodyExpNeeded(user);
    }
}

