/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.LogiaInvulnerabilityAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class KenbunshokuHakiFutureSightAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kenbunshoku_haki_future_sight", new Pair[]{ImmutablePair.of((Object)"Using Observation Haki allows the user to see a short period into the future to avoid attacks.", null)});
    private static final int MIN_COOLDOWN = 100;
    public static final AbilityCore<KenbunshokuHakiFutureSightAbility> INSTANCE = new AbilityCore.Builder<KenbunshokuHakiFutureSightAbility>("Kenbunshoku Haki: Future Sight", AbilityCategory.HAKI, KenbunshokuHakiFutureSightAbility::new).addDescriptionLine(DESCRIPTION).setUnlockCheck(KenbunshokuHakiFutureSightAbility::canUnlock).build();
    public static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.BUSOSHOKU_HAKI_ARM).setColor(new Color(255, 100, 200, 100)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::damageTakenEvent, DamageTakenComponent.DamageState.ATTACK);
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.DODGE_ABILITY, new AbilityPool2[0]);
    private final StackComponent stackComponent = new StackComponent(this).addStackChangeEvent(this::changeStackEvent);
    private boolean hasDodged;
    private int protTimer;
    private int invulnerabilityTimer = 0;

    public KenbunshokuHakiFutureSightAbility(AbilityCore<KenbunshokuHakiFutureSightAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent, this.skinOverlayComponent, this.poolComponent, this.stackComponent);
        this.addCanUseCheck(HakiHelper::canEnableHaki);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
        this.addEquipEvent(this::equipEvent);
    }

    private void equipEvent(LivingEntity entity, Ability ability) {
        this.stackComponent.setDefaultStacks(this.calculateMaxProtection(entity));
        this.stackComponent.revertStacksToDefault(entity, ability);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void changeStackEvent(LivingEntity entity, IAbility ability, int stacks) {
        if (stacks <= 0) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HAKI_GUARD.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.stackComponent.setDefaultStacks(this.calculateMaxProtection(entity));
        this.stackComponent.revertStacksToDefault(entity, ability);
        this.invulnerabilityTimer = 0;
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.KENBUNSHOKU_HAKI_ON_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(entity, 2);
        if (isOnMaxOveruse) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.HAKI_GUARD.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.continuousComponent.stopContinuity(entity);
        }
        if (this.protTimer > 0) {
            --this.protTimer;
        } else if (this.protTimer <= 0 && this.hasDodged) {
            this.skinOverlayComponent.hideAll(entity);
            this.hasDodged = false;
        }
        if (this.invulnerabilityTimer > 0) {
            --this.invulnerabilityTimer;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.KENBUNSHOKU_HAKI_OFF.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.skinOverlayComponent.hideAll(entity);
        float protLost = (this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 6;
        float cooldown = 100.0f + WyHelper.secondsToTicks(protLost);
        this.cooldownComponent.startCooldown(entity, cooldown);
        this.stackComponent.revertStacksToDefault(entity, this);
    }

    private int calculateMaxProtection(LivingEntity entity) {
        IEntityStats sprops = EntityStatsCapability.get(entity);
        IHakiData hakiProps = HakiDataCapability.get(entity);
        double dorikiPower = sprops.getDoriki() / 5000.0;
        double hakiPower = hakiProps.getKenbunshokuHakiExp() / 12.0f;
        return (int)Math.max(1L, Math.round(dorikiPower + hakiPower));
    }

    public void reduceProtection(LivingEntity entity, float damage) {
        if (this.invulnerabilityTimer == 0) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.FUTURE_SIGHT_HIT.get(), SoundCategory.PLAYERS, 2.0f, 0.75f + entity.func_70681_au().nextFloat() / 2.0f);
            int stacks = Math.max(1, Math.round(damage / 15.0f));
            this.stackComponent.addStacks(entity, this, -stacks);
            this.protTimer = 4;
            this.invulnerabilityTimer = 10;
            this.hasDodged = true;
        }
        WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(entity, this), entity);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74768_a("protectionTimer", this.protTimer);
        nbt.func_74768_a("invulnerabilityTimer", this.invulnerabilityTimer);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.protTimer = nbt.func_74762_e("protectionTimer");
        this.invulnerabilityTimer = nbt.func_74762_e("invulnerabilityTimer");
    }

    public float damageTakenEvent(LivingEntity entity, IAbility ability, DamageSource source, float damage) {
        boolean isUnavoidable;
        int absorbed;
        if (!super.isContinuous() || !AbilityHelper.canUseMomentumAbilities(entity)) {
            return damage;
        }
        IHakiData hakiProps = HakiDataCapability.get(entity);
        int hakiOveruse = 10 + hakiProps.getMaxOveruse() / 1180;
        boolean isLogia = DevilFruitCapability.get(entity).isLogia();
        LogiaInvulnerabilityAbility invulnerabilityInstance = null;
        if (isLogia) {
            IAbilityData abilityProps = AbilityDataCapability.get(entity);
            Set unlockedAbilities = abilityProps.getPassiveAbilities(AbilityCategory.DEVIL_FRUITS.isAbilityPartofCategory());
            for (IAbility otherAbility : unlockedAbilities) {
                if (otherAbility == null || !(otherAbility instanceof LogiaInvulnerabilityAbility)) continue;
                invulnerabilityInstance = (LogiaInvulnerabilityAbility)otherAbility;
            }
            hakiOveruse /= 3;
        } else if (source.func_94541_c()) {
            return damage;
        }
        ArrayList<DamageSource> damageableSources = new ArrayList<DamageSource>(Arrays.asList(DamageSource.field_76371_c, DamageSource.field_76368_d, DamageSource.field_76367_g, DamageSource.field_220302_v, DamageSource.field_76366_f, DamageSource.field_82728_o, DamageSource.field_188406_j, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_76380_i, DamageSource.field_82727_n, DamageSource.field_76376_m, DamageSource.field_76372_a, DamageSource.field_76370_b, DamageSource.field_180137_b));
        if (!(this.getInvulnerabilityTimer() <= 0 || damageableSources.contains(source) || source.func_76355_l().equals("special") || isLogia)) {
            return 0.0f;
        }
        if (!source.func_76363_c()) {
            damage = CombatRules.func_189427_a((float)damage, (float)entity.func_70658_aO(), (float)((float)entity.func_110148_a(Attributes.field_233827_j_).func_111126_e()));
        }
        if ((absorbed = EnchantmentHelper.func_77508_a((Iterable)entity.func_184193_aE(), (DamageSource)source)) > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)absorbed);
        }
        if (damage < 0.0f) {
            return 0.0f;
        }
        boolean baseCondition = damageableSources.stream().noneMatch(s -> source.func_76355_l().equals(s.func_76355_l()));
        boolean bl = isUnavoidable = source instanceof ModDamageSource && ((ModDamageSource)source).isUnavoidable() || source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w();
        if (this.getInvulnerabilityTimer() > 0) {
            return 0.0f;
        }
        if (baseCondition && !isUnavoidable && this.getInvulnerabilityTimer() == 0) {
            this.skinOverlayComponent.showAll(entity);
            this.reduceProtection(entity, damage);
            hakiProps.alterHakiOveruse(hakiOveruse * 4 + (int)(damage * (float)hakiOveruse));
            return 0.0f;
        }
        return damage;
    }

    private static boolean canUnlock(LivingEntity user) {
        IAbilityData abilityProps = AbilityDataCapability.get(user);
        IHakiData props = HakiDataCapability.get(user);
        IEntityStats statsProps = EntityStatsCapability.get(user);
        boolean hasAuraUnlocked = abilityProps.hasUnlockedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        return hasAuraUnlocked && statsProps.getDoriki() > 6000.0 && (double)props.getKenbunshokuHakiExp() > HakiHelper.getKenbunshokuFutureSightExpNeeded(user);
    }

    public int getInvulnerabilityTimer() {
        return this.invulnerabilityTimer;
    }

    public int getProtectionStacks() {
        return this.stackComponent.getStacks();
    }

    public int getMaxProtectionStacks() {
        return this.stackComponent.getDefaultStacks();
    }
}

