/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hana;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.hana.HanaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class CienFleurWingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "cien_fleur_wing", new Pair[]{ImmutablePair.of((Object)"Sprouts two big wings made out of limbs on the user's back and allows them to gently float down taking no fall damage.", null)});
    private static final int HOLD_TIME = 200;
    private static final int MIN_COOLDOWN = 40;
    private static final int MAX_COOLDOWN = 200;
    public static final AbilityCore<CienFleurWingAbility> INSTANCE = new AbilityCore.Builder<CienFleurWingAbility>("Cien Fleur: Wing", AbilityCategory.DEVIL_FRUITS, CienFleurWingAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 200.0f), ContinuousComponent.getTooltip(200.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::damageTakenEvent, DamageTakenComponent.DamageState.ATTACK);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public CienFleurWingAbility(AbilityCore<CienFleurWingAbility> ability) {
        super(ability);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.damageTakenComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::requiresInAir);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        HanaHelper.spawnBlossomEffect(entity);
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_233570_aj_()) {
            this.continuousComponent.stopContinuity(entity);
        }
        entity.func_213293_j(entity.func_213322_ci().field_72450_a / 1.2, entity.func_213322_ci().field_72448_b / 5.0, entity.func_213322_ci().field_72449_c / 1.2);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        float cooldown = Math.max(40.0f, this.continuousComponent.getContinueTime());
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float damageTakenEvent(LivingEntity user, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }
}

