/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horu;

import java.util.function.Predicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class TensionHormoneAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tension_hormone", new Pair[]{ImmutablePair.of((Object)"The user injects the target with special hormones providing a supply of adrenaline that strengthens them.", null), ImmutablePair.of((Object)"\u00a7aSHIFT-USE\u00a7r: User injects themselves", null)});
    private static final int COOLDOWN = 400;
    public static final AbilityCore<TensionHormoneAbility> INSTANCE = new AbilityCore.Builder<TensionHormoneAbility>("Tension Hormone", AbilityCategory.DEVIL_FRUITS, TensionHormoneAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ContinuousComponent.getTooltip()).build();

    public TensionHormoneAbility(AbilityCore<TensionHormoneAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.hitTriggerComponent.setBypassSameGroupProtection();
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (entity.func_213453_ef()) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.TENSION_HORMONE.get(), 200, 1));
            this.cooldownComponent.startCooldown(entity, 400.0f);
        }
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        target.func_195064_c(new EffectInstance((Effect)ModEffects.TENSION_HORMONE.get(), 200, 1));
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchCooldown() {
        return 400.0f;
    }
}

