/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SoraNoMichiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sora_no_michi", new Pair[]{ImmutablePair.of((Object)"The user attaches the strings to clouds, allowing them to move through the air", null)});
    private static final int JUMPS = 12;
    private static final float SHORT_COOLDOWN_PER_STACK = 10.0f;
    private static final float LONG_COOLDOWN_PER_STACK = 40.0f;
    public static final AbilityCore<SoraNoMichiAbility> INSTANCE = new AbilityCore.Builder<SoraNoMichiAbility>("Sora no Michi", AbilityCategory.DEVIL_FRUITS, SoraNoMichiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, AbilityHelper.createShortLongCooldownStat(10.0f, 40.0f), StackComponent.getTooltip(12)).build();
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GEPPO_LIKE, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final StackComponent stackComponent = new StackComponent(this);
    private boolean hasFallDamage = true;

    public SoraNoMichiAbility(AbilityCore<SoraNoMichiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.poolComponent, this.damageTakenComponent, this.stackComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addCanUseCheck(this::canUse);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
        if (!entity.field_70170_p.field_72995_K) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217216_a((Entity)entity, (IPacket)new SAnimateHandPacket((Entity)entity, 0));
        }
        int stacksUsed = 1;
        if (entity.func_233570_aj_()) {
            Vector3d speed = WyHelper.propulsion(entity, 1.1, 1.1);
            entity.func_213293_j(speed.field_72450_a, 2.4, speed.field_72449_c);
        } else {
            Vector3d speed = WyHelper.propulsion(entity, 2.5, 2.5);
            entity.func_213293_j(speed.field_72450_a, 0.8, speed.field_72449_c);
        }
        entity.field_70133_I = true;
        this.stackComponent.addStacks(entity, this, -stacksUsed);
        this.hasFallDamage = false;
        if (this.stackComponent.getStacks() <= 0) {
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
            this.stackComponent.setStacks(entity, this, this.getMaxJumps(entity));
        } else {
            this.cooldownComponent.startCooldown(entity, 10.0f);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!this.hasFallDamage && damageSource == DamageSource.field_76379_h) {
            this.resetStacks(entity);
            return 0.0f;
        }
        return damage;
    }

    private void resetStacks(LivingEntity entity) {
        if (this.stackComponent.getStacks() != this.stackComponent.getDefaultStacks()) {
            this.cooldownComponent.stopCooldown(entity);
            this.cooldownComponent.startCooldown(entity, this.getCooldownTicks());
        }
        this.stackComponent.setStacks(entity, this, this.getMaxJumps(entity));
        this.stackComponent.setDefaultStacks(this.getMaxJumps(entity));
        this.hasFallDamage = true;
    }

    private int getMaxJumps(LivingEntity entity) {
        return 12;
    }

    private float getCooldownTicks() {
        return (float)(this.stackComponent.getDefaultStacks() - this.stackComponent.getStacks()) * 40.0f;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74757_a("hasFallDamage", this.hasFallDamage);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.hasFallDamage = nbt.func_74767_n("hasFallDamage");
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        if (entity.func_226278_cu_() > 128.0) {
            return AbilityUseResult.fail(null);
        }
        return AbilityUseResult.success();
    }
}

