/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;

public class TorikagoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "torikago", new Pair[]{ImmutablePair.of((Object)"Creates an indestructible dome made of strings, that damage anyone who touches them", null)});
    public static final int MAX_CAGE_SIZE = 60;
    private static final int MIN_CAGE_SIZE = 8;
    private static final int CHARGE_TIME = 60;
    private static final int MAX_COOLDOWN = 200;
    private static final float MIN_COOLDOWN = 26.666668f;
    public static final AbilityCore<TorikagoAbility> INSTANCE = new AbilityCore.Builder<TorikagoAbility>("Torikago", AbilityCategory.DEVIL_FRUITS, TorikagoAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(26.666668f, 200.0f), ChargeComponent.getTooltip(60.0f), ContinuousComponent.getTooltip()).build();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE).addApprovedBlocks(ModBlocks.STRING_WALL).setBypassGriefRule().build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, true).addStartEvent(100, this::startChargeEvent).addEndEvent(100, this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(100, this::tickContinuousEvent).addEndEvent(100, this::endContinuousEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private List<BlockPos> blockList = new ArrayList<BlockPos>();
    private List<BlockPos> placedBlockList = new ArrayList<BlockPos>();
    public int cageSize = 0;
    private BlockPos centerPos;
    private Interval checkPositionInterval = new Interval(20);

    public TorikagoAbility(AbilityCore<TorikagoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.continuousComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.RAISE_RIGHT_ARM, 60);
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.blockList.isEmpty()) {
            this.cageSize = Math.max(8, (int)(60.0f * (this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime())));
            this.centerPos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.blockList.addAll(AbilityHelper.createSphere(entity.field_70170_p, entity.func_233580_cy_(), this.cageSize, true, (Block)ModBlocks.STRING_WALL.get(), 0, GRIEF_RULE));
            this.placedBlockList.addAll(this.blockList);
        }
        this.continuousComponent.startContinuity(entity, -1.0f);
        this.animationComponent.stop(entity);
    }

    private void tickContinuousEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.centerPos != null && this.checkPositionInterval.canTick() && !this.isPositionInTorikago(entity.func_233580_cy_())) {
            this.continuousComponent.stopContinuity(entity);
        }
        int placedBlocks = 0;
        Iterator<BlockPos> iter = this.placedBlockList.iterator();
        while (iter.hasNext()) {
            BlockPos pos = iter.next();
            entity.field_70170_p.func_184138_a(pos, Blocks.field_150350_a.func_176223_P(), ((Block)ModBlocks.STRING_WALL.get()).func_176223_P(), 0);
            iter.remove();
            if (++placedBlocks <= 512) continue;
            return;
        }
    }

    private void endContinuousEvent(LivingEntity entity, IAbility ability) {
        for (BlockPos pos : this.blockList) {
            Block currentBlock = entity.field_70170_p.func_180495_p(pos).func_177230_c();
            if (currentBlock != ModBlocks.STRING_WALL.get()) continue;
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.centerPos = null;
        this.blockList.clear();
        this.placedBlockList.clear();
        float cooldown = 200.0f * ((float)this.cageSize / 60.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public boolean isPositionInTorikago(BlockPos pos) {
        if (this.centerPos == null) {
            return false;
        }
        return pos.func_218141_a((Vector3i)this.centerPos, (double)this.cageSize);
    }

    public BlockPos getCenter() {
        return this.centerPos;
    }
}

