/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.abilities.jiki.PunkGibsonAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.DamnedPunkProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class DamnedPunkAbility
extends Ability {
    private static final int VALUE_PER_PROJECTILE = 15;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "damned_punk", new Pair[]{ImmutablePair.of((Object)"Transforms the users arm into a railgun that shoots a projectile with every swing using %s magnetic objects from the users inventory per shoot, dealing massive damage on impact.", (Object)new Object[]{AbilityHelper.mentionText(15)})});
    private static final int HOLD_TIME = 500;
    private static final int COOLDOWN = 400;
    public static final AbilityCore<DamnedPunkAbility> INSTANCE = new AbilityCore.Builder<DamnedPunkAbility>("Damned Punk", AbilityCategory.DEVIL_FRUITS, DamnedPunkAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(400.0f), ContinuousComponent.getTooltip(500.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent(this).addSwingEvent(this::swingEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PUNK_GIBSON.get(), new MorphInfo[0]);
    private final MorphComponent morphComponent = new MorphComponent(this);

    public DamnedPunkAbility(AbilityCore<DamnedPunkAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.swingTriggerComponent, this.projectileComponent, this.requireMorphComponent, this.morphComponent);
        this.addCanUseCheck(this::canUse);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 500.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.DAMNED_PUNK.get());
        PunkGibsonAbility punkGibson = AbilityDataCapability.get(entity).getEquippedAbility(PunkGibsonAbility.INSTANCE);
        if (punkGibson != null && punkGibson.isContinuous()) {
            punkGibson.activateDamnedPunk(entity);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.morphComponent.stopMorph(entity);
        PunkGibsonAbility punkGibson = AbilityDataCapability.get(entity).getEquippedAbility(PunkGibsonAbility.INSTANCE);
        if (punkGibson != null && punkGibson.isContinuous()) {
            punkGibson.activatePunkGibson(entity);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }

    private void swingEvent(LivingEntity entity, IAbility ability) {
        if (!this.continuousComponent.isContinuous()) {
            return;
        }
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        if (!JikiHelper.hasEnoughIron(inventory, 15.0f)) {
            entity.func_145747_a((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_MATERIALS, Util.field_240973_b_);
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.projectileComponent.shoot(entity, 7.0f, 0.0f);
        JikiHelper.spawnAttractEffect((Entity)entity);
    }

    private DamnedPunkProjectile createProjectile(LivingEntity entity) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        List<ItemStack> components = JikiHelper.getMagneticItemsNeeded(inventory, 15.0f);
        DamnedPunkProjectile proj = new DamnedPunkProjectile(entity.field_70170_p, entity, components);
        return proj;
    }

    private AbilityUseResult canUse(LivingEntity entity, IAbility ability) {
        Ability abl = AbilityDataCapability.get(entity).getEquippedAbility(PunkGibsonAbility.INSTANCE);
        if (abl != null && abl.isContinuous()) {
            return AbilityUseResult.success();
        }
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        if (!JikiHelper.hasEnoughIron(inventory, 15.0f)) {
            return AbilityUseResult.fail((ITextComponent)ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_MATERIALS);
        }
        return AbilityUseResult.fail(null);
    }
}

