/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.abilities.sabi.RustSkinAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.GenocideRaidEffectEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.jiki.GenocideRaidProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class GenocideRaidAbility
extends Ability {
    public static final int REQUIRED_IRON = 20;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "genocide_raid", new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic items and sends them towards the target, spiriling around it and dealing damage over time.", (Object)new Object[]{AbilityHelper.mentionText(20)})});
    private static final int COOLDOWN = 200;
    public static final int EFFECT_TIMER = 100;
    public static final AbilityCore<GenocideRaidAbility> INSTANCE = new AbilityCore.Builder<GenocideRaidAbility>("Genocide Raid", AbilityCategory.DEVIL_FRUITS, GenocideRaidAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).setSourceType(SourceType.BLUNT).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public GenocideRaidAbility(AbilityCore<GenocideRaidAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addCanUseCheck(JikiHelper.getMetalicItemsCheck(20));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        JikiHelper.spawnAttractEffect((Entity)entity);
        this.projectileComponent.shoot(entity, 6.0f, 0.0f);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }

    private GenocideRaidProjectile createProjectile(LivingEntity entity) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        List<ItemStack> magneticItems = JikiHelper.getMagneticItemsNeeded(inventory, 20.0f);
        GenocideRaidProjectile proj = new GenocideRaidProjectile(entity.field_70170_p, entity);
        proj.onEntityImpactEvent = target -> {
            RustSkinAbility rustSkinAbility;
            IAbilityData abilityDataProps = AbilityDataCapability.get(target);
            if (abilityDataProps != null && (rustSkinAbility = abilityDataProps.getPassiveAbility(RustSkinAbility.INSTANCE)) != null && !rustSkinAbility.isPaused()) {
                proj.func_174812_G();
                return;
            }
            target.func_195064_c(new EffectInstance((Effect)ModEffects.GENOCIDE_RAID.get(), 100, 0));
            JikiHelper.spawnAttractEffect((Entity)target);
            GenocideRaidEffectEntity effect = new GenocideRaidEffectEntity(entity.field_70170_p);
            effect.func_70012_b(target.func_226277_ct_(), target.func_226278_cu_() + 1.0, target.func_226281_cx_(), 0.0f, 0.0f);
            effect.setTarget(target);
            effect.setOwner(entity);
            effect.setItemsUsed(magneticItems);
            entity.field_70170_p.func_217376_c((Entity)effect);
        };
        proj.onBlockImpactEvent = hitPos -> {
            GenocideRaidEffectEntity effect = new GenocideRaidEffectEntity(entity.field_70170_p);
            effect.func_70012_b(hitPos.func_177958_n(), hitPos.func_177956_o() + 1, hitPos.func_177952_p(), 0.0f, 0.0f);
            effect.setTarget(null);
            effect.setOwner(entity);
            effect.setItemsUsed(magneticItems);
            entity.field_70170_p.func_217376_c((Entity)effect);
        };
        return proj;
    }
}

