/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.jiki;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.jiki.JikiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PunkCornaDioAbility
extends Ability {
    private static final int REQUIRED_IRON = 160;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "punk_corna_dio", new Pair[]{ImmutablePair.of((Object)"Uses %s magnetic items from the inventory to create a bull which can then be used to smash into enemies dealing huge damage, knocking them away and potentially stunning them.", (Object)new Object[]{AbilityHelper.mentionText(160)})});
    private static final int CHARGE_TIME = 60;
    private static final int HOLD_TIME = 100;
    private static final int COOLDOWN = 200;
    private static final int RANGE = 6;
    private static final float DAMAGE = 100.0f;
    public static final AbilityCore<PunkCornaDioAbility> INSTANCE = new AbilityCore.Builder<PunkCornaDioAbility>("Punk Corna Dio", AbilityCategory.DEVIL_FRUITS, PunkCornaDioAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(60.0f), DealDamageComponent.getTooltip(100.0f)).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceElement(SourceElement.METAL).setSourceType(SourceType.BLUNT).build();
    private static final AbilityAttributeModifier TOUGHNESS_MODIFIER = new AbilityAttributeModifier(UUID.fromString("aa76fb8e-9123-424c-954a-7e19007491f8"), INSTANCE, "Punk Corna DIO Toughness Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private static final AbilityAttributeModifier STEP_HEIGHT_MODIFIER = new AbilityAttributeModifier(UUID.fromString("d9824f43-df79-4664-a0a6-b4324236834e"), INSTANCE, "Punk Corna DIO Step Height Modifier", 3.0, AttributeModifier.Operation.ADDITION);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargeEvent);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final MorphComponent morphComponent = new MorphComponent(this);
    private final ChangeStatsComponent changeStatsComponent = new ChangeStatsComponent(this);
    private List<ItemStack> magneticItems = new ArrayList<ItemStack>();

    public PunkCornaDioAbility(AbilityCore<PunkCornaDioAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.continuousComponent, this.hitTrackerComponent, this.rangeComponent, this.dealDamageComponent, this.morphComponent, this.changeStatsComponent);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.TOUGHNESS, (AttributeModifier)TOUGHNESS_MODIFIER);
        this.changeStatsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.STEP_HEIGHT, (AttributeModifier)STEP_HEIGHT_MODIFIER);
        this.addCanUseCheck(JikiHelper.getMetalicItemsCheck(160));
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            return;
        }
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        List<ItemStack> inventory = ItemsHelper.getAllInventoryItems(entity);
        this.magneticItems = JikiHelper.getMagneticItemsNeeded(inventory, 160.0f);
        this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.PUNK_CORNA_DIO.get());
        this.changeStatsComponent.applyModifiers(entity);
        this.hitTrackerComponent.clearHits();
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 2, false, false));
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 100.0f);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 2, 2, false, false));
        if (this.magneticItems.size() <= 0) {
            this.continuousComponent.stopContinuity(entity);
        }
        Vector3d lookVec = entity.func_70040_Z();
        Vector3d speed = lookVec.func_216372_d(2.3, 0.0, 2.3);
        entity.func_213315_a(MoverType.SELF, speed);
        if (this.continuousComponent.getContinueTime() % 25.0f == 0.0f) {
            this.hitTrackerComponent.clearHits();
        }
        Vector3d knockbackVec = lookVec.func_216372_d(4.0, 1.0, 4.0);
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 6.0f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 100.0f)) continue;
            if (WyHelper.randomDouble() > 0.75) {
                entity.func_195064_c(new EffectInstance((Effect)ModEffects.DIZZY.get(), 100, 1, false, false));
            }
            target.func_213293_j(knockbackVec.field_72450_a, 0.2, knockbackVec.field_72449_c);
            target.field_70133_I = true;
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.magneticItems != null && this.magneticItems.size() > 0) {
            ItemStack stack = this.magneticItems.get(0);
            ItemsHelper.itemBreakParticles(entity, 160, stack);
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), SoundEvents.field_187635_cQ, entity.func_184176_by(), 0.5f, 1.0f);
            JikiHelper.dropComponentItems(entity, entity.func_213303_ch(), this.magneticItems);
        }
        this.morphComponent.stopMorph(entity);
        this.changeStatsComponent.removeModifiers(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

