/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.DoppelmanEntity;

public class DoppelmanAbility
extends Ability {
    private static final int HOLD_TIME = 12000;
    private static final int MIN_COOLDOWN = 40;
    private static final int MAX_COOLDOWN = 6000;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "doppelman", new Pair[]{ImmutablePair.of((Object)"Creates a living version of the user's shadow to help them fight", null)});
    public static final AbilityCore<DoppelmanAbility> INSTANCE = new AbilityCore.Builder<DoppelmanAbility>("Doppelman", AbilityCategory.DEVIL_FRUITS, DoppelmanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(40.0f, 6000.0f), ContinuousComponent.getTooltip()).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::startContinuityEvent).addTickEvent(100, this::onTickEvent).addEndEvent(100, this::stopContinuityEvent);
    private final StackComponent stackComponent = new StackComponent(this);
    private DoppelmanEntity doppelman = null;
    private int shadowsUsed = 0;
    private int prevShadowsUsed = 0;

    public DoppelmanAbility(AbilityCore<DoppelmanAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.stackComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.doppelman = new DoppelmanEntity(entity.field_70170_p, entity);
        this.doppelman.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
        if (!entity.field_70170_p.field_72995_K) {
            this.doppelman.setShadow(this.shadowsUsed);
            this.stackComponent.setStacks(entity, this, this.shadowsUsed);
        }
        entity.field_70170_p.func_217376_c((Entity)this.doppelman);
    }

    private void onTickEvent(LivingEntity entity, IAbility ability) {
        if (this.doppelman == null || !this.doppelman.func_70089_S()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        this.shadowsUsed = this.doppelman.getShadows();
        if (this.shadowsUsed != this.prevShadowsUsed) {
            this.stackComponent.setStacks(entity, this, this.shadowsUsed);
            this.prevShadowsUsed = this.shadowsUsed;
        }
    }

    private void stopContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.doppelman != null) {
            this.doppelman.func_70106_y();
        }
        this.prevShadowsUsed = 0;
        float cooldown = MathHelper.func_76131_a((float)this.continuousComponent.getContinueTime(), (float)40.0f, (float)6000.0f);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    @Nullable
    public DoppelmanEntity getDoppelman() {
        return this.doppelman;
    }

    public void doppelmanDeathTrigger(LivingEntity owner) {
        this.shadowsUsed = 0;
        this.stackComponent.setStacks(owner, this, 0);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74768_a("shadows", this.shadowsUsed);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.shadowsUsed = nbt.func_74762_e("shadows");
    }
}

