/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.kage.KageHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.NightmareSoldierEntity;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NightmareSoldiersAbility
extends Ability {
    private static final int CHARGE_TIME = 200;
    private static final int MIN_COOLDOWN = 100;
    private static final int MAX_COOLDOWN = 300;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "nightmare_soldiers", new Pair[]{ImmutablePair.of((Object)"Creates Nightmare Soldiers using Shadows from the user's inventory, the longer the ability charges the more soldiers it'll create", null)});
    public static final AbilityCore<NightmareSoldiersAbility> INSTANCE = new AbilityCore.Builder<NightmareSoldiersAbility>("Nightmare Soldiers", AbilityCategory.DEVIL_FRUITS, NightmareSoldiersAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 300.0f), ChargeComponent.getTooltip(200.0f)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> this.getShadowsUsed() > 0).addTickEvent(100, this::duringChargingEvent).addEndEvent(100, this::stopChargingEvent);
    private final StackComponent stackComponent = new StackComponent(this);
    private int prevShadowValue;

    public NightmareSoldiersAbility(AbilityCore<NightmareSoldiersAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.stackComponent);
        this.addCanUseCheck(this::canUseCheck);
        this.addUseEvent(this::onUseEvent);
    }

    private AbilityUseResult canUseCheck(LivingEntity entity, IAbility ability) {
        if (ItemsHelper.countItemInInventory(entity, (Item)ModItems.SHADOW.get()) <= 0) {
            return AbilityUseResult.fail(KageHelper.NOT_ENOUGH_SHADOWS_WARN);
        }
        return AbilityUseResult.success();
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 200.0f);
    }

    private void duringChargingEvent(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && this.chargeComponent.getChargeTime() % 2.0f == 0.0f) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.CHARGE_KAGE.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 20, 2, false, false));
        int shadowsUsed = this.getShadowsUsed();
        if (ItemsHelper.countItemInInventory(entity, (Item)ModItems.SHADOW.get()) < shadowsUsed) {
            entity.func_145747_a(KageHelper.NOT_ENOUGH_SHADOWS_WARN, Util.field_240973_b_);
            this.chargeComponent.stopCharging(entity);
            return;
        }
        if (shadowsUsed != this.prevShadowValue) {
            this.stackComponent.setStacks(entity, this, shadowsUsed);
            this.prevShadowValue = shadowsUsed;
        }
    }

    private boolean stopChargingEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, this.chargeComponent.getChargeTime() + 100.0f);
        int shadowsUsed = this.getShadowsUsed();
        KageHelper.removeShadows(entity, shadowsUsed);
        for (int i = 0; i < shadowsUsed; ++i) {
            NightmareSoldierEntity soldier = new NightmareSoldierEntity(entity.field_70170_p);
            soldier.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
            soldier.setOwner(entity);
            entity.field_70170_p.func_217376_c((Entity)soldier);
        }
        this.prevShadowValue = 0;
        this.stackComponent.setStacks(entity, this, 0);
        return true;
    }

    private int getShadowsUsed() {
        return (int)(this.chargeComponent.getChargeTime() / 40.0f);
    }
}

