/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.kage.KageHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.MorphAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.StackComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class ShadowsAsgardAbility
extends MorphAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shadows_asgard", new Pair[]{ImmutablePair.of((Object)"By continuously absorbing Shadows the user's strenght increases as well as their size", null)});
    private static final float HOLD_TIME = 1200.0f;
    private static final float MIN_COOLDOWN = 200.0f;
    private static final float MAX_COOLDOWN = 1400.0f;
    private static final int MAX_SHADOWS = 30;
    private static final float MIN_STAT = 0.0f;
    private static final float MAX_ARMOR_STAT = 10.0f;
    private static final float MAX_ATTACK_STAT = 10.0f;
    private static final float MAX_REACH_STAT = 2.0f;
    private static final float MAX_TOUGHNESS_STAT = 5.0f;
    private static final float MAX_STEP_ASSIST_STAT = 1.0f;
    private static final float MAX_KNOCKBACK_RES_STAT = 1.0f;
    private static final float MAX_HEALTH_STAT = 1.0f;
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("c9f0e77d-6cd6-498e-b032-6641daaa1081");
    private static final UUID ATTACK_MODIFIER_UUID = UUID.fromString("ad79a8f6-0e4e-4cfb-9df0-1ce833eee85c");
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("5d8c2020-c5f7-48c5-8825-b482bc8efff4");
    private static final UUID TOUGHNESS_MODIFIER_UUID = UUID.fromString("80f4aecd-effc-4843-8d53-945de5b0c251");
    private static final UUID STEP_ASSIST_MODIFIER_UUID = UUID.fromString("bf11a9e2-ffb5-4eca-8c01-9068338a838d");
    private static final UUID KNOCKBACK_RES_MODIFIER_UUID = UUID.fromString("c774bb23-72f4-48d3-84e4-e3aff157f1e7");
    private static final UUID MAX_HEALTH_MODIFIER_UUID = UUID.fromString("6f12c985-570c-420d-97d7-f972b0875f98");
    private static final AbilityDescriptionLine.IDescriptionLine STATS_TOOLTIP = (entity, ability) -> {
        TranslationTextComponent armorAttrName = new TranslationTextComponent(Attributes.field_233826_i_.func_233754_c_());
        ITextComponent armorStatText = new AbilityStat.Builder((ITextComponent)armorAttrName, 0.0f, 10.0f).build().getStatDescription(2);
        TranslationTextComponent attackAttrName = new TranslationTextComponent(Attributes.field_233823_f_.func_233754_c_());
        ITextComponent attackStatText = new AbilityStat.Builder((ITextComponent)attackAttrName, 0.0f, 10.0f).build().getStatDescription(2);
        TranslationTextComponent reachAttrName = new TranslationTextComponent(((Attribute)ModAttributes.ATTACK_RANGE.get()).func_233754_c_());
        ITextComponent reachStatText = new AbilityStat.Builder((ITextComponent)reachAttrName, 0.0f, 2.0f).build().getStatDescription(2);
        TranslationTextComponent toughnessAttrName = new TranslationTextComponent(((Attribute)ModAttributes.TOUGHNESS.get()).func_233754_c_());
        ITextComponent toughnessStatText = new AbilityStat.Builder((ITextComponent)toughnessAttrName, 0.0f, 5.0f).build().getStatDescription(2);
        TranslationTextComponent stepAssistAttrName = new TranslationTextComponent(((Attribute)ModAttributes.STEP_HEIGHT.get()).func_233754_c_());
        ITextComponent stepAssistStatText = new AbilityStat.Builder((ITextComponent)stepAssistAttrName, 0.0f, 1.0f).build().getStatDescription(2);
        TranslationTextComponent knockbackResAttrName = new TranslationTextComponent(Attributes.field_233820_c_.func_233754_c_());
        ITextComponent knockbackResStatText = new AbilityStat.Builder((ITextComponent)knockbackResAttrName, 0.0f, 1.0f).build().getStatDescription(2);
        TranslationTextComponent maxHealthAttrName = new TranslationTextComponent(Attributes.field_233818_a_.func_233754_c_());
        ITextComponent maxHealthStatText = new AbilityStat.Builder((ITextComponent)maxHealthAttrName, 0.0f, 1.0f).build().getStatDescription(2);
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_STATS.getString() + "\u00a7r\n");
        sb.append(armorStatText.getString() + "\n");
        sb.append(attackStatText.getString() + "\n");
        sb.append(reachStatText.getString() + "\n");
        sb.append(toughnessStatText.getString() + "\n");
        sb.append(stepAssistStatText.getString() + "\n");
        sb.append(knockbackResStatText.getString() + "\n");
        sb.append(maxHealthStatText.getString());
        return new StringTextComponent(sb.toString());
    };
    public static final AbilityCore<ShadowsAsgardAbility> INSTANCE = new AbilityCore.Builder<ShadowsAsgardAbility>("Shadow's Asgard", AbilityCategory.DEVIL_FRUITS, ShadowsAsgardAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f, 1400.0f), ContinuousComponent.getTooltip(1200.0f), STATS_TOOLTIP).build();
    private final StackComponent stackComponent = new StackComponent(this);
    private int shadows = 0;

    public ShadowsAsgardAbility(AbilityCore<ShadowsAsgardAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.stackComponent);
        this.continuousComponent.addStartEvent(120, this::onStartContinuityEvent);
        this.continuousComponent.addTickEvent(120, this::onTickContinuityEvent);
        this.continuousComponent.addEndEvent(120, this::onEndContinuityEvent);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.shadows = 0;
        this.morphComponent.updateMorphSize(entity);
    }

    private void onTickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (KageHelper.hasEnoughShadows(entity, this, 1).isFail()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (this.continuousComponent.getContinueTime() % 10.0f == 0.0f && this.shadows < 30) {
            this.statsComponent.removeModifiers(entity);
            this.statsComponent.clearAttributeModifiers();
            for (Map.Entry entry : this.getAttributes().entries()) {
                this.statsComponent.addAttributeModifier((Attribute)entry.getKey(), (AttributeModifier)entry.getValue());
            }
            this.statsComponent.applyModifiers(entity);
            ++this.shadows;
            this.stackComponent.setStacks(entity, this, this.shadows);
            KageHelper.removeShadows(entity, 1);
            this.morphComponent.updateMorphSize(entity);
        }
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.stackComponent.setStacks(entity, ability, 0);
        this.cooldownComponent.startCooldown(entity, 200.0f + this.continuousComponent.getContinueTime());
    }

    private Multimap<Attribute, AttributeModifier> getAttributes() {
        HashMultimap map = HashMultimap.create();
        map.put((Object)Attributes.field_233826_i_, (Object)new AbilityAttributeModifier(ARMOR_MODIFIER_UUID, INSTANCE, "Shadows Asgard Armor Modifier", this.getArmorValue(), AttributeModifier.Operation.ADDITION));
        map.put((Object)Attributes.field_233823_f_, (Object)new AbilityAttributeModifier(ATTACK_MODIFIER_UUID, INSTANCE, "Shadows Asgard Attack Modifier", this.getDamageValue(), AttributeModifier.Operation.ADDITION));
        AbilityAttributeModifier reachAttribute = new AbilityAttributeModifier(REACH_MODIFIER_UUID, INSTANCE, "Shadows Asgard Reach Modifier", this.getReachValue(), AttributeModifier.Operation.ADDITION);
        map.put((Object)ForgeMod.REACH_DISTANCE.get(), (Object)reachAttribute);
        map.put((Object)ModAttributes.ATTACK_RANGE.get(), (Object)reachAttribute);
        map.put((Object)ModAttributes.TOUGHNESS.get(), (Object)new AbilityAttributeModifier(TOUGHNESS_MODIFIER_UUID, INSTANCE, "Shadows Asgard Toughness Modifier", this.getToughnessValue(), AttributeModifier.Operation.ADDITION));
        map.put((Object)ModAttributes.STEP_HEIGHT.get(), (Object)new AbilityAttributeModifier(STEP_ASSIST_MODIFIER_UUID, INSTANCE, "Shadows Asgard Step Assist Modifier", this.getStepAssistValue(), AttributeModifier.Operation.ADDITION));
        map.put((Object)Attributes.field_233820_c_, (Object)new AbilityAttributeModifier(KNOCKBACK_RES_MODIFIER_UUID, INSTANCE, "Shadows Asgard Knockback Resistance Modifier", this.getKnockbackResAssistValue(), AttributeModifier.Operation.ADDITION));
        map.put((Object)Attributes.field_233818_a_, (Object)new AbilityAttributeModifier(MAX_HEALTH_MODIFIER_UUID, INSTANCE, "Shadows Asgard Max Health Modifier", this.getMaxHealthValue(), AttributeModifier.Operation.ADDITION));
        return map;
    }

    private double getArmorValue() {
        return Math.min((float)(this.shadows + 1) / 30.0f * 10.0f, 10.0f);
    }

    private double getDamageValue() {
        return Math.min((float)(this.shadows + 1) / 30.0f * 10.0f, 10.0f);
    }

    private double getReachValue() {
        return Math.min((float)(this.shadows + 1) / 30.0f * 2.0f, 2.0f);
    }

    private double getToughnessValue() {
        return Math.min((float)(this.shadows + 1) / 30.0f * 5.0f, 5.0f);
    }

    private double getStepAssistValue() {
        return Math.min((float)(this.shadows + 1 + 15) / 30.0f * 1.0f, 1.0f);
    }

    private double getKnockbackResAssistValue() {
        return Math.min((float)(this.shadows + 1 + 15) / 30.0f * 1.0f, 1.0f);
    }

    private double getMaxHealthValue() {
        return Math.min((float)(this.shadows + 1) / 30.0f * 1.0f, 1.0f);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt = super.save(nbt);
        nbt.func_74768_a("shadows", this.shadows);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.shadows = nbt.func_74762_e("shadows");
    }

    @Override
    public MorphInfo getTransformation() {
        return (MorphInfo)ModMorphs.SHADOWS_ASGARD.get();
    }

    public int getShadows() {
        return this.shadows;
    }

    @Override
    public float getContinuityHoldTime() {
        return 1200.0f;
    }
}

