/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.karu;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.karu.IngaZarashiAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PassiveAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GaugeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SSyncAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class KarmaAbility
extends PassiveAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "karma", new Pair[]{ImmutablePair.of((Object)"Converts received damage into karma.", null)});
    private static final DecimalFormat FORMAT = new DecimalFormat("#0.0");
    public static final float MAX_KARMA = 100.0f;
    public static final AbilityCore<KarmaAbility> INSTANCE = new AbilityCore.Builder<KarmaAbility>("Karma", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, KarmaAbility::new).addDescriptionLine(DESCRIPTION).build();
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.DAMAGE);
    private float karma = 0.0f;
    private float prevKarma = 0.0f;

    public KarmaAbility(AbilityCore<KarmaAbility> ability) {
        super(ability);
        this.addComponents(this.damageTakenComponent);
        if (super.isClientSide()) {
            GaugeComponent gaugeComponent = new GaugeComponent(this, this::renderGauge);
            super.addComponents(gaugeComponent);
        }
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (damageSource.func_82725_o() || this.karma >= 100.0f) {
            return damage;
        }
        if (damageSource instanceof ModDamageSource) {
            boolean isInternal = ((ModDamageSource)damageSource).isInternal();
            if (!isInternal) {
                this.addKarma(entity, damage);
            }
        } else {
            this.addKarma(entity, damage);
        }
        return damage;
    }

    public void addKarma(LivingEntity entity, float amount) {
        this.prevKarma = this.karma;
        this.karma = MathHelper.func_76131_a((float)(this.karma + amount), (float)0.0f, (float)100.0f);
        if (entity instanceof PlayerEntity) {
            WyNetwork.sendTo(new SSyncAbilityPacket(entity.func_145782_y(), this), (PlayerEntity)entity);
        }
    }

    public float getKarma() {
        return this.karma;
    }

    public void setPrevKarma(float prevKarma) {
        this.prevKarma = prevKarma;
    }

    public float getPrevKarma() {
        return this.prevKarma;
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74776_a("karma", this.karma);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        this.karma = nbt.func_74760_g("karma");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderGauge(PlayerEntity player, MatrixStack matrixStack, int posX, int posY, KarmaAbility ability) {
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
        RendererHelper.drawAbilityIcon(IngaZarashiAbility.INSTANCE, matrixStack, posX, posY - 38, 0, 32.0f, 32.0f);
        String karma = FORMAT.format(ability.getKarma());
        WyHelper.drawStringWithBorder(Minecraft.func_71410_x().field_71466_p, matrixStack, karma, posX + 16 - mc.field_71466_p.func_78256_a(karma) / 2, posY - 25, Color.WHITE.getRGB());
        RenderSystem.disableBlend();
    }
}

