/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kilo;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityAttributeModifier;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class KiloPress1Ability
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "1_kilo_press", new Pair[]{ImmutablePair.of((Object)"Makes the user become extremely light, their jumps become higher and they can use an Umbrella to float", null)});
    private static final float HOLD_TIME = 1200.0f;
    private static final float MIN_COOLDOWN = 20.0f;
    private static final float MAX_COOLDOWN = 1220.0f;
    public static final AbilityCore<KiloPress1Ability> INSTANCE = new AbilityCore.Builder<KiloPress1Ability>("1 Kilo Press", AbilityCategory.DEVIL_FRUITS, KiloPress1Ability::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 1220.0f), ContinuousComponent.getTooltip(1200.0f), ChangeStatsComponent.getTooltip()).build();
    private static final AbilityAttributeModifier KILO_PRESS_JUMP_HEIGHT = new AbilityAttributeModifier(UUID.fromString("8626d3b9-c2ed-470e-94aa-280e2ceff116"), INSTANCE, "Kilo Press Jump Height Modifier", 25.0, AttributeModifier.Operation.ADDITION);
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(100, this::startContinuityEvent).addEndEvent(100, this::endContinuityEvent);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final ChangeStatsComponent statsComponent = new ChangeStatsComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public KiloPress1Ability(AbilityCore<KiloPress1Ability> core) {
        super(core);
        this.isNew = true;
        this.statsComponent.addAttributeModifier((Supplier<Attribute>)ModAttributes.JUMP_HEIGHT, (AttributeModifier)KILO_PRESS_JUMP_HEIGHT, entity -> this.continuousComponent.isContinuous());
        this.addComponents(this.continuousComponent, this.statsComponent, this.damageTakenComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 1200.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.KILO_PRESS, -1, user -> this.isContinuous() && !user.func_233570_aj_());
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        float cooldown = 20.0f + this.continuousComponent.getContinueTime();
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.continuousComponent.isContinuous() && damageSource == DamageSource.field_76379_h) {
            return 0.0f;
        }
        return damage;
    }
}

