/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kobu;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ShoureiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "shourei", new Pair[]{ImmutablePair.of((Object)"Increases other people's fighting spirit and physical strength by simply encouraging them with words.", null)});
    private static final TargetsPredicate TARGETS_CHECK = new TargetsPredicate().testFriendlyFaction();
    private static final int COOLDOWN = 1200;
    private static final int RANGE = 20;
    public static final AbilityCore<ShoureiAbility> INSTANCE = new AbilityCore.Builder<ShoureiAbility>("Shourei", AbilityCategory.DEVIL_FRUITS, ShoureiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1200.0f), RangeComponent.getTooltip(20.0f, RangeComponent.RangeType.AOE)).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public ShoureiAbility(AbilityCore<ShoureiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 20.0f, TARGETS_CHECK);
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance(Effects.field_76420_g, 600, 1, true, false, true));
            target.func_195064_c(new EffectInstance(Effects.field_76424_c, 600, 1, true, false, true));
            target.func_195064_c(new EffectInstance(Effects.field_76429_m, 600, 1, true, false, true));
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, 600, 0, true, false, true));
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SHOUREI.get(), (Entity)entity, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        }
        this.cooldownComponent.startCooldown(entity, 1200.0f);
    }
}

