/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kuku;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class GourmetamorphosisAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "gourmetamorphosis", new Pair[]{ImmutablePair.of((Object)"Makes all items in the user's inventory edible.", null)});
    private static final int HOLD_TIME = 1200;
    private static final int MIN_COOLDOWN = 20;
    private static final int MAX_COOLDOWN = 620;
    public static final AbilityCore<GourmetamorphosisAbility> INSTANCE = new AbilityCore.Builder<GourmetamorphosisAbility>("Gourmetamorphosis", AbilityCategory.DEVIL_FRUITS, GourmetamorphosisAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f, 620.0f), ContinuousComponent.getTooltip(1200.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(this::endContinuityEvent);

    public GourmetamorphosisAbility(AbilityCore<GourmetamorphosisAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        float cooldown = 20.0f + this.continuousComponent.getContinueTime() / 2.0f;
        this.cooldownComponent.startCooldown(entity, cooldown);
    }
}

