/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mandemontactics;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.DropHitAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DemonicDanceAbility
extends DropHitAbility2 {
    private static final int COOLDOWN = 260;
    private static final float RANGE = 1.25f;
    private static final float DAMAGE = 30.0f;
    private static final float CHARGE_TIME = 40.0f;
    public static final TargetsPredicate TARGET_TEST = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<DemonicDanceAbility> INSTANCE = new AbilityCore.Builder<DemonicDanceAbility>("Demonic Dance", AbilityCategory.STYLE, DemonicDanceAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(260.0f), ChargeComponent.getTooltip(40.0f), RangeComponent.getTooltip(1.25f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(30.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.BLUNT).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addEndEvent(this::endChargeEvent);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(40);
    @Nullable
    private Entity target;
    private boolean isStandard;

    public DemonicDanceAbility(AbilityCore<DemonicDanceAbility> core) {
        super((AbilityCore<? extends DropHitAbility2>)core);
        this.addComponents(this.chargeComponent, this.dealDamageComponent, this.rangeComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::requiresTonfaWeapon);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
        this.continuousComponent.addTickEvent(100, this::tickContinuityEvent);
    }

    @Override
    protected void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 40.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.DEMONIC_DANCE_CHARGE, (int)this.chargeComponent.getMaxChargeTime());
    }

    private void endChargeEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.continuousComponent.startContinuity(entity);
        this.animationComponent.start(entity, ModAnimations.DEMONIC_DANCE_LEAP);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        if (this.target != null) {
            Vector3d speed = this.target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b().func_216372_d(2.0, 1.0, 2.0);
            entity.func_213293_j(speed.field_72450_a, 0.5, speed.field_72449_c);
        } else {
            Vector3d speed = entity.func_70040_Z().func_216372_d(2.0, 0.0, 2.0);
            entity.func_213293_j(speed.field_72450_a, 0.5, speed.field_72449_c);
        }
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70143_R > 0.0f && !this.hasLanded()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.25f, TARGET_TEST);
            for (LivingEntity livingEntity : targets) {
                if (!this.hitTrackerComponent.canHit((Entity)livingEntity)) continue;
                ItemsHelper.stopShieldAndStartCooldown(livingEntity, 100);
                this.dealDamageComponent.hurtTarget(entity, livingEntity, 15.0f);
                this.setLanded();
            }
            for (Entity entity2 : this.hitTrackerComponent.getHits()) {
                if (!(DevilFruitHelper.getDifferenceToFloor(entity2) > 1.5)) continue;
                entity2.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() - 1.0, entity.func_226281_cx_());
            }
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.target = null;
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 260.0f);
    }

    @Override
    public void onLanding(LivingEntity entity) {
        for (Entity target : this.hitTrackerComponent.getHits()) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity livingTarget = (LivingEntity)target;
            if (!this.isStandard) {
                livingTarget.func_195064_c(new EffectInstance((Effect)ModEffects.UNCONSCIOUS.get(), 20, 0, false, false));
            }
            this.dealDamageComponent.hurtTarget(entity, livingTarget, 15.0f);
        }
        ArrayList<Vector3d> positions = new ArrayList<Vector3d>();
        int range = (int)Math.ceil(1.25);
        for (int x = -range; x < range; ++x) {
            for (int z = -range; z < range; ++z) {
                double posX = entity.func_226277_ct_() + (double)x;
                double posY = entity.func_226278_cu_() - 1.0;
                double posZ = entity.func_226281_cx_() + (double)z;
                Vector3d pos = new Vector3d(posX, posY, posZ);
                positions.add(pos);
            }
        }
        if (positions.size() > 0) {
            this.details.setVecPositions(positions);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
        }
        this.continuousComponent.stopContinuity(entity);
    }

    public void setStandardMode() {
        this.isStandard = true;
    }

    public void setTarget(Entity target) {
        this.target = target;
    }

    public Entity getTarget() {
        return this.target;
    }
}

