/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mandemontactics;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Vector3d;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.math.VectorHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class DemonicSmashAbility
extends Ability {
    private static final int COOLDOWN = 160;
    private static final float RANGE = 1.25f;
    private static final float DAMAGE = 20.0f;
    public static final TargetsPredicate TARGET_TEST = new TargetsPredicate().testEnemyFaction().testSimpleInView();
    public static final AbilityCore<DemonicSmashAbility> INSTANCE = new AbilityCore.Builder<DemonicSmashAbility>("Demonic Smash", AbilityCategory.STYLE, DemonicSmashAbility::new).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f), RangeComponent.getTooltip(1.25f, RangeComponent.RangeType.LINE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.BLUNT).build();
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private boolean isLookingRight = true;

    public DemonicSmashAbility(AbilityCore<DemonicSmashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.dealDamageComponent, this.animationComponent);
        this.addCanUseCheck(AbilityHelper::requiresTonfaWeapon);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.25f, 1.5f);
        this.isLookingRight = entity.func_70681_au().nextBoolean();
        this.animationComponent.start(entity, ModAnimations.DEMONIC_SMASH, 7);
        Vector3d dir = VectorHelper.calculateRotationBasedOffsetPosition(entity.func_213303_ch(), entity.field_70177_z, this.isLookingRight ? -5.0 : 5.0, 0.0, 0.0);
        Vector3d move = entity.func_213303_ch().func_178788_d(dir);
        for (LivingEntity target : targets) {
            ItemsHelper.stopShieldAndStartCooldown(target, 100);
            if (!this.dealDamageComponent.hurtTarget(entity, target, 20.0f)) continue;
            target.func_213317_d(move);
            target.field_70133_I = true;
        }
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }
}

