/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mane;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.IExtensibleEnum;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.MorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class ManeManeMemoryAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mane_mane_memory", new Pair[]{ImmutablePair.of((Object)"While in COPY mode hitting others will memorize their properties, other modes represent the memories the user can change into.", null)});
    private static final int COOLDOWN = 20;
    public static final AbilityCore<ManeManeMemoryAbility> INSTANCE = new AbilityCore.Builder<ManeManeMemoryAbility>("Mane Mane Memory", AbilityCategory.DEVIL_FRUITS, ManeManeMemoryAbility::new).addDescriptionLine(DESCRIPTION).build();
    private static final ManeMemory EMPTY_MEMORY = new ManeMemory();
    private List<ManeMemory> memories = new ArrayList<ManeMemory>();
    private int memoryId;
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(100, this::hitEvent);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.COPY).addChangeModeEvent(this::changeModeEvent);
    private final MorphComponent morphComponent = new MorphComponent(this);

    public ManeManeMemoryAbility(AbilityCore<ManeManeMemoryAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTriggerComponent, this.morphComponent, this.altModeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (!this.memories.isEmpty() && this.getMemory().isValidMemory()) {
            this.morphComponent.startMorph(entity, (MorphInfo)ModMorphs.MANE_MEMORY.get());
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MANE_SWITCH.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).refreshDisplayName();
            }
        }
    }

    private HitTriggerComponent.HitResult hitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (this.continuousComponent.isContinuous() && this.altModeComponent.getCurrentMode() == Mode.COPY && target instanceof PlayerEntity && !this.memories.stream().anyMatch(mem -> mem.getUUID().equals(target.func_110124_au()))) {
            source.canBypassFriendlyDamage();
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.MANE_SWITCH.get(), SoundCategory.PLAYERS, 1.0f, 0.2f);
            this.addMemory(entity, target);
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.getMemory().isValidMemory()) {
            this.morphComponent.stopMorph(entity);
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).refreshDisplayName();
            }
        }
        this.cooldownComponent.startCooldown(entity, 20.0f);
    }

    private void changeModeEvent(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.COPY) {
            this.memoryId = -1;
            return;
        }
        for (int i = 0; i < this.memories.size(); ++i) {
            if (!this.memories.get(i).equals(mode.getMemory())) continue;
            this.memoryId = i;
            break;
        }
    }

    public void addMemory(LivingEntity entity, LivingEntity target) {
        entity.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_MANE_ADDED_MEMORY, new Object[]{target.func_145748_c_().getString()}), Util.field_240973_b_);
        ManeMemory memory = ManeMemory.from(target);
        this.memories.add(memory);
        Mode.create(target.func_145748_c_().getString(), memory);
    }

    public ManeMemory getMemory() {
        if (this.memoryId < 0) {
            return EMPTY_MEMORY;
        }
        if (this.memories.isEmpty()) {
            return EMPTY_MEMORY;
        }
        return this.memories.get(this.memoryId);
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        nbt.func_74768_a("memoryId", this.memoryId);
        ListNBT list = new ListNBT();
        for (ManeMemory memory : this.memories) {
            list.add((Object)memory.saveTargetData());
        }
        nbt.func_218657_a("memories", (INBT)list);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        this.memoryId = nbt.func_74762_e("memoryId");
        this.memories.clear();
        ListNBT list = (ListNBT)nbt.func_74781_a("memories");
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT memoryNBT = list.func_150305_b(i);
            ManeMemory memory = new ManeMemory();
            memory.loadTargetData(memoryNBT);
            this.memories.add(memory);
            Mode.create(memory.getDisplayName(), memory);
        }
    }

    static /* synthetic */ ManeMemory access$000() {
        return EMPTY_MEMORY;
    }

    public static class ManeMemory {
        private UUID uuid = ModValues.NIL_UUID;
        private String displayName = "";
        private String profileName = "";
        private GameProfile gameProfile = null;
        private boolean isPlayer;
        private double doriki;
        private String faction = "";
        private String race = "";
        private String subRace = "";
        private String fightingStyle = "";
        private float kenbunshokuExp;
        private float busoshokuHardeningExp;

        public static ManeMemory from(LivingEntity target) {
            ManeMemory memory = new ManeMemory();
            IEntityStats stats = EntityStatsCapability.get(target);
            IHakiData hakiData = HakiDataCapability.get(target);
            memory.uuid = target.func_110124_au();
            memory.displayName = target.func_145748_c_().getString();
            memory.profileName = target.func_200200_C_().getString();
            if (target instanceof PlayerEntity) {
                memory.gameProfile = ((PlayerEntity)target).func_146103_bH();
                memory.profileName = memory.gameProfile.getName();
                memory.isPlayer = true;
            }
            memory.doriki = stats.getDoriki();
            memory.faction = stats.getFaction();
            memory.race = stats.getRace();
            memory.subRace = stats.getSubRace();
            memory.fightingStyle = stats.getFightingStyle();
            memory.kenbunshokuExp = hakiData.getKenbunshokuHakiExp();
            memory.busoshokuHardeningExp = hakiData.getBusoshokuHakiExp();
            return memory;
        }

        public boolean isValidMemory() {
            return !this.uuid.equals(ModValues.NIL_UUID);
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public GameProfile getGameProfile() {
            return this.gameProfile;
        }

        public String getProfileName() {
            return this.profileName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ManeMemory)) {
                return false;
            }
            ManeMemory memory = (ManeMemory)o;
            return memory.getUUID().equals(this.uuid);
        }

        public CompoundNBT saveTargetData() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_186854_a("uuid", this.uuid);
            nbt.func_74778_a("displayName", this.displayName);
            nbt.func_74778_a("profileName", this.profileName);
            nbt.func_74757_a("isPlayer", this.isPlayer);
            nbt.func_74780_a("doriki", this.doriki);
            nbt.func_74778_a("faction", this.faction);
            nbt.func_74778_a("race", this.race);
            nbt.func_74778_a("subRace", this.subRace);
            nbt.func_74778_a("fightingStyle", this.fightingStyle);
            nbt.func_74776_a("kenbunshokuExp", this.kenbunshokuExp);
            nbt.func_74776_a("busoshokuHardeningExp", this.busoshokuHardeningExp);
            return nbt;
        }

        public void loadTargetData(CompoundNBT nbt) {
            this.uuid = nbt.func_186857_a("uuid");
            this.displayName = nbt.func_74779_i("displayName");
            this.profileName = nbt.func_74779_i("profileName");
            this.isPlayer = nbt.func_74767_n("isPlayer");
            this.doriki = nbt.func_74769_h("doriki");
            this.faction = nbt.func_74779_i("faction");
            this.race = nbt.func_74779_i("race");
            this.subRace = nbt.func_74779_i("subRace");
            this.fightingStyle = nbt.func_74779_i("fightingStyle");
            this.kenbunshokuExp = nbt.func_74760_g("kenbunshokuExp");
            this.busoshokuHardeningExp = nbt.func_74760_g("busoshokuHardeningExp");
            if (this.isPlayer) {
                this.gameProfile = new GameProfile(this.uuid, this.profileName);
            }
        }
    }

    private static enum Mode implements IExtensibleEnum
    {
        COPY(ManeManeMemoryAbility.access$000());

        private ManeMemory memory;

        private Mode(ManeMemory memory) {
            this.memory = memory;
        }

        public ManeMemory getMemory() {
            return this.memory;
        }

        public static Mode create(String name, ManeMemory memory) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

