/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.mera.MeraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.HidarumaProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HidarumaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "hidaruma", new Pair[]{ImmutablePair.of((Object)"Creates small green fireballs that set the target on fire", null)});
    private static final int COOLDOWN = 200;
    private static final int MIN_FIREFLIES = 6;
    private static final int MAX_FIREFLIES = 9;
    public static final AbilityCore<HidarumaAbility> INSTANCE = new AbilityCore.Builder<HidarumaAbility>("Hidaruma", AbilityCategory.DEVIL_FRUITS, HidarumaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public HidarumaAbility(AbilityCore<HidarumaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        super.addCanUseCheck(MeraHelper::canUseMeraAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity player, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 100.0);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        BlockPos originPos = new BlockPos(i, j, k);
        Optional<LivingEntity> target = null;
        List list = WyHelper.getNearbyLiving(mop.func_216347_e(), (IWorld)player.field_70170_p, 10.0, ModEntityPredicates.getEnemyFactions(player));
        list.sort(MobsHelper.ENTITY_THREAT);
        if (list.size() > 0) {
            target = list.stream().findAny();
            originPos = ((LivingEntity)target.get()).func_233580_cy_();
        }
        int random = (int)WyHelper.randomWithRange(6, 9);
        for (int n = 0; n < random; ++n) {
            BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation(player.field_70170_p, (EntityType)MeraProjectiles.HIDARUMA.get(), originPos, 10, 7);
            if (spawnPos == null) continue;
            HidarumaProjectile proj = (HidarumaProjectile)((Object)this.projectileComponent.getNewProjectile(player));
            proj.setTarget(target);
            proj.func_70107_b(spawnPos.func_177958_n(), (double)spawnPos.func_177956_o() + 1.0, spawnPos.func_177952_p());
            player.field_70170_p.func_217376_c((Entity)proj);
        }
        this.cooldownComponent.startCooldown(player, 200.0f);
    }

    private HidarumaProjectile createProjectile(LivingEntity entity) {
        HidarumaProjectile proj = new HidarumaProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

