/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.mera.MeraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.HiganProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class HiganAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "higan", new Pair[]{ImmutablePair.of((Object)"Turns the user's fingertips into flames and shoots bullets made of fire from them", null)});
    private static final int COOLDOWN = 180;
    public static final AbilityCore<HiganAbility> INSTANCE = new AbilityCore.Builder<HiganAbility>("Higan", AbilityCategory.DEVIL_FRUITS, HiganAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(180.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public HiganAbility(AbilityCore<HiganAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.repeaterComponent, this.animationComponent, this.projectileComponent);
        super.addCanUseCheck(MeraHelper::canUseMeraAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        this.repeaterComponent.start(entity, 10, 2);
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.repeaterComponent.stop(entity);
        }
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 180.0f);
    }

    private HiganProjectile createProjectile(LivingEntity entity) {
        HiganProjectile proj = new HiganProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

