/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.mera.MeraHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.JujikaProjectile;

public class JujikaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "jujika", new Pair[]{ImmutablePair.of((Object)"Launches a cross-shaped column of fire at the opponent", null)});
    private static final int COOLDOWN = 240;
    public static final AbilityCore<JujikaAbility> INSTANCE = new AbilityCore.Builder<JujikaAbility>("Jujika", AbilityCategory.DEVIL_FRUITS, JujikaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.FIRE).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public JujikaAbility(AbilityCore<JujikaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        super.addCanUseCheck(MeraHelper::canUseMeraAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private JujikaProjectile createProjectile(LivingEntity entity) {
        JujikaProjectile proj = new JujikaProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

