/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mogu;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.BreakingBlocksParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MoguraTonpoAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mogura_tonpo", new Pair[]{ImmutablePair.of((Object)"Digs a massive tunnel forwards while in mole form", null)});
    private static final float COOLDOWN = 240.0f;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 15.0f;
    public static final AbilityCore<MoguraTonpoAbility> INSTANCE = new AbilityCore.Builder<MoguraTonpoAbility>("Mogura Tonpo", AbilityCategory.DEVIL_FRUITS, MoguraTonpoAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), DealDamageComponent.getTooltip(15.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onStartContinuityEvent).addTickEvent(100, this::onTickContinuityEvent).addEndEvent(100, this::onEndContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTaken, DamageTakenComponent.DamageState.ATTACK);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.MOGU_HEAVY.get(), new MorphInfo[0]);
    private BreakingBlocksParticleEffect.Details details = new BreakingBlocksParticleEffect.Details(20);
    private float initialY;
    private boolean hasFallProt;

    public MoguraTonpoAbility(AbilityCore<MoguraTonpoAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.hitTrackerComponent, this.damageTakenComponent, this.dealDamageComponent, this.rangeComponent, this.requireMorphComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.startContinuity(entity, 10.0f);
    }

    private void onStartContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        this.hasFallProt = true;
        this.initialY = (int)entity.func_226278_cu_();
        Vector3d speed = WyHelper.propulsion(entity, 2.0, 2.0);
        entity.func_213293_j(speed.field_72450_a, 0.1, speed.field_72449_c);
        entity.field_70133_I = true;
    }

    private void onTickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!entity.func_70089_S() || entity.func_226278_cu_() < (double)this.initialY) {
            return;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.6f, 1.6f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target)) continue;
            this.dealDamageComponent.hurtTarget(entity, target, 15.0f);
        }
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (BlockPos location : WyHelper.getNearbyBlocks((Entity)entity, 3)) {
            if (!((float)location.func_177956_o() >= this.initialY)) continue;
            BlockState tempBlock = entity.field_70170_p.func_180495_p(location);
            if (!AbilityHelper.placeBlockIfAllowed(entity, location, Blocks.field_150350_a.func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).field_71071_by.func_70441_a(new ItemStack((IItemProvider)tempBlock.func_177230_c()));
            }
            positions.add(location);
        }
        if (positions.size() > 0) {
            this.details.setPositions(positions);
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BREAKING_BLOCKS.get(), (Entity)entity, 0.0, 0.0, 0.0, this.details);
        }
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private float onDamageTaken(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (this.hasFallProt && damageSource == DamageSource.field_76379_h) {
            this.hasFallProt = false;
            return 0.0f;
        }
        return damage;
    }
}

