/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.FlyAbility;
import xyz.pixelatedw.mineminenomi.abilities.moku.WhiteLauncherAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MokuFlyAbility
extends FlyAbility {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "moku_special_fly", new Pair[]{ImmutablePair.of((Object)"Allows the user to fly", null)});
    public static final AbilityCore<MokuFlyAbility> INSTANCE = new AbilityCore.Builder<MokuFlyAbility>("Moku Special Fly", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, MokuFlyAbility::new).addDescriptionLine(DESCRIPTION).build();

    public MokuFlyAbility(AbilityCore<MokuFlyAbility> core) {
        super((AbilityCore)core);
    }

    @Override
    public Supplier<ParticleEffect<?>> getParticleEffects() {
        return ModParticleEffects.MOKU_FLY;
    }

    @Override
    public int getHeightDifference(PlayerEntity player) {
        return 30;
    }

    @Override
    public float getSpeedMultiplier(PlayerEntity player) {
        boolean whiteLauncherInUse;
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        if (abilityDataProps == null) {
            return 0.0f;
        }
        WhiteLauncherAbility whiteLauncher = abilityDataProps.getEquippedAbility(WhiteLauncherAbility.INSTANCE);
        boolean bl = whiteLauncherInUse = whiteLauncher != null && whiteLauncher.getComponent(ModAbilityKeys.CONTINUOUS).map(comp -> comp.isContinuous() && comp.getContinueTime() <= 15.0f).orElse(false) != false;
        if (whiteLauncherInUse) {
            return 1.0f;
        }
        float speed = 0.5f;
        if (!WyHelper.isInCombat((LivingEntity)player)) {
            speed += speed * 0.3f;
        }
        return speed;
    }
}

