/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.moku.WhiteBlowRushProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class WhiteBlowRushAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "white_blow_rush", new Pair[]{ImmutablePair.of((Object)"Shoots clouds of smoke to engulf the opponent and trap them", null)});
    private static final int COOLDOWN = 120;
    public static final AbilityCore<WhiteBlowRushAbility> INSTANCE = new AbilityCore.Builder<WhiteBlowRushAbility>("White Blow Rush", AbilityCategory.DEVIL_FRUITS, WhiteBlowRushAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(120.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceElement(SourceElement.SMOKE).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::onRepeaterTrigger).addStopEvent(this::onRepeaterStop);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public WhiteBlowRushAbility(AbilityCore<WhiteBlowRushAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.repeaterComponent, this.animationComponent, this.projectileComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        this.repeaterComponent.start(entity, 8, 3);
    }

    private void onRepeaterTrigger(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.repeaterComponent.stop(entity);
        }
        this.projectileComponent.shoot(entity, 2.75f, 4.0f);
    }

    private void onRepeaterStop(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 120.0f);
    }

    private WhiteBlowRushProjectile createProjectile(LivingEntity entity) {
        WhiteBlowRushProjectile proj = new WhiteBlowRushProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

