/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WhiteLauncherAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "white_launcher", new Pair[]{ImmutablePair.of((Object)"Transforms the user into smoke and launches them forward", null)});
    private static final int COOLDOWN = 200;
    private static final float RANGE = 1.6f;
    private static final float DAMAGE = 15.0f;
    public static final int ON_HOLD = 15;
    public static final AbilityCore<WhiteLauncherAbility> INSTANCE = new AbilityCore.Builder<WhiteLauncherAbility>("White Launcher", AbilityCategory.DEVIL_FRUITS, WhiteLauncherAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(15.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(15.0f)).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final Interval particleInterval = new Interval(2);

    public WhiteLauncherAbility(AbilityCore<WhiteLauncherAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.hitTrackerComponent, this.rangeComponent, this.dealDamageComponent);
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        if (!AbilityHelper.canUseMomentumAbilities(entity)) {
            return;
        }
        this.continuousComponent.startContinuity(entity);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.continuousComponent.getContinueTime() > 15.0f) {
            if (entity.func_233570_aj_()) {
                this.continuousComponent.stopContinuity(entity);
                return;
            }
            return;
        }
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
        Vector3d dir = entity.func_70040_Z().func_72432_b().func_186678_a(3.0);
        entity.func_213317_d(dir);
        if (entity instanceof PlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)entity));
        }
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.WHITE_LAUNCHER.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.6f);
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !entity.func_70685_l((Entity)target)) continue;
            target.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(entity, this, "player"), 15.0f);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

