/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.netsu;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.RepeaterAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.netsu.NekkaiGyoraiProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;

public class NekkaiGyoraiAbility
extends RepeaterAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "nekkai_gyorai", new Pair[]{ImmutablePair.of((Object)"Shoots heat-torpedoes, exploding and setting the enemy on fire.", null)});
    private static final int COOLDOWN = 100;
    private static final int TRIGGERS = 5;
    private static final int INTERVAL = 5;
    public static final AbilityCore<NekkaiGyoraiAbility> INSTANCE = new AbilityCore.Builder<NekkaiGyoraiAbility>("Nekkai Gyorai", AbilityCategory.DEVIL_FRUITS, NekkaiGyoraiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public NekkaiGyoraiAbility(AbilityCore<NekkaiGyoraiAbility> core) {
        super((AbilityCore<? extends RepeaterAbility2>)core);
        this.addComponents(this.animationComponent);
        this.continuousComponent.addStartEvent(this::startContinuityEvent);
        this.continuousComponent.addEndEvent(this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
    }

    @Override
    public int getMaxTriggers() {
        return 5;
    }

    @Override
    public int getTriggerInterval() {
        return 5;
    }

    @Override
    public float getRepeaterCooldown() {
        return 100.0f;
    }

    public NekkaiGyoraiProjectile getProjectileFactory(LivingEntity entity) {
        NekkaiGyoraiProjectile proj = new NekkaiGyoraiProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

