/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nikyu;

import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SwingTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.PainEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class PainRepelAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "pain_repel", new Pair[]{ImmutablePair.of((Object)"Extracts all the damage their target has suffered condensing it into a small paw-shaped ball.", null)});
    private static final float COOLDOWN = 1200.0f;
    public static final AbilityCore<PainRepelAbility> INSTANCE = new AbilityCore.Builder<PainRepelAbility>("Pain Repel", AbilityCategory.DEVIL_FRUITS, PainRepelAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(1200.0f)).setSourceHakiNature(SourceHakiNature.SPECIAL).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final HitTriggerComponent hitTriggerComponent = new HitTriggerComponent(this).addOnHitEvent(100, this::onHitEvent);
    private final SwingTriggerComponent swingTriggerComponent = new SwingTriggerComponent(this).addSwingEvent(0, this::onSwing);
    private Interval painAddInterval = new Interval(10);
    private LivingEntity target;
    private State state = State.IDLE;
    private float pain = 0.0f;
    private float initialTargetHealthDiff = 0.0f;

    public PainRepelAbility(AbilityCore<PainRepelAbility> core) {
        super(core);
        this.isNew = true;
        this.hitTriggerComponent.setBypassSameGroupProtection();
        super.addComponents(this.continuousComponent, this.hitTriggerComponent, this.swingTriggerComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private HitTriggerComponent.HitResult onHitEvent(LivingEntity entity, LivingEntity target, ModDamageSource source, IAbility ability) {
        if (target.func_110143_aJ() >= target.func_110138_aP()) {
            return HitTriggerComponent.HitResult.PASS;
        }
        if (AbilityHelper.isTargetBlocking(entity, target)) {
            return HitTriggerComponent.HitResult.PASS;
        }
        if (this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b() && this.state == State.IDLE) {
            this.state = State.HEALING;
            this.target = target;
            this.initialTargetHealthDiff = target.func_110138_aP() - target.func_110143_aJ();
            return HitTriggerComponent.HitResult.FAIL;
        }
        return HitTriggerComponent.HitResult.PASS;
    }

    private void onSwing(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b() && this.state == State.READY) {
            PainEntity proj = new PainEntity(entity.field_70170_p, entity);
            proj.setDamage(this.pain);
            proj.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, 2.0f, 1.0f);
            entity.field_70170_p.func_217376_c((Entity)proj);
            this.continuousComponent.stopContinuity(entity);
        }
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.state == State.IDLE) {
            return;
        }
        if (this.target != null && this.state == State.HEALING) {
            float diff;
            this.target.field_70125_A = this.target.field_70127_C;
            this.target.field_70177_z = this.target.field_70126_B;
            if (this.target instanceof PlayerEntity) {
                EnumSet<SPlayerPositionLookPacket.Flags> flags = EnumSet.of(SPlayerPositionLookPacket.Flags.X, SPlayerPositionLookPacket.Flags.Y, SPlayerPositionLookPacket.Flags.Z);
                ((ServerPlayerEntity)this.target).field_71135_a.func_175089_a(this.target.func_226277_ct_(), this.target.func_226278_cu_(), this.target.func_226281_cx_(), this.target.field_70126_B, this.target.field_70127_C, flags);
            }
            this.target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 5, 3));
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
            if (this.painAddInterval.canTick()) {
                float extraPain = this.target.func_110138_aP() / 10.0f;
                this.pain += extraPain;
                this.target.func_70691_i(extraPain);
                entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PAD_HO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
            }
            if (((diff = this.target.func_110138_aP() - this.target.func_110143_aJ()) <= 0.0f || this.pain >= this.initialTargetHealthDiff) && !entity.field_82175_bq) {
                this.state = State.READY;
            }
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.target = null;
        this.state = State.IDLE;
        this.pain = 0.0f;
        this.initialTargetHealthDiff = 0.0f;
        this.cooldownComponent.startCooldown(entity, 1200.0f);
    }

    private static enum State {
        IDLE,
        HEALING,
        READY;

    }
}

