/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.noro;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.noro.NoroNoroBeamProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class NoroNoroBeamAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "noro_noro_beam", new Pair[]{ImmutablePair.of((Object)"Shoots a beam of photons at the opponent, completely slowing them down (multiple hits stack the Slowness effect)", null)});
    private static final float COOLDOWN = 60.0f;
    private static final int ANIMATION_TICK = 10;
    public static final AbilityCore<NoroNoroBeamAbility> INSTANCE = new AbilityCore.Builder<NoroNoroBeamAbility>("Noro Noro Beam", AbilityCategory.DEVIL_FRUITS, NoroNoroBeamAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public NoroNoroBeamAbility(AbilityCore<NoroNoroBeamAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent, this.animationComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.AIM_SNIPER, 10);
        this.projectileComponent.shoot(entity, 4.0f, 1.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.NORO_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }

    private NoroNoroBeamProjectile createProjectile(LivingEntity entity) {
        NoroNoroBeamProjectile proj = new NoroNoroBeamProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

