/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.ope.OpeHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.SoulboundItemHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModItems;

public class MesAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "mes", new Pair[]{ImmutablePair.of((Object)"Removes the heart of the user's target which they can then damage to hurt the opponent", null)});
    private static final float COOLDOWN = 600.0f;
    public static final AbilityCore<MesAbility> INSTANCE = new AbilityCore.Builder<MesAbility>("MES", AbilityCategory.DEVIL_FRUITS, MesAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();

    public MesAbility(AbilityCore<MesAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.continuousComponent.addTickEvent(100, this::onContinuityTick);
        this.addCanUseCheck(OpeHelper::hasRoomActive);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (!entity.field_70170_p.field_72995_K && OpeHelper.hasRoomActive(entity, this).isFail()) {
            this.continuousComponent.stopContinuity(entity);
        }
    }

    @Override
    public float getPunchCooldown() {
        return 600.0f;
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        boolean targetNoHeart;
        IDevilFruit props = DevilFruitCapability.get(target);
        if (props.hasDevilFruit(ModAbilities.WARA_WARA_NO_MI)) {
            for (int i = 0; i < ((PlayerEntity)target).field_71071_by.field_70462_a.size(); ++i) {
                if (((ItemStack)((PlayerEntity)target).field_71071_by.field_70462_a.get(i)).func_77973_b() != ModItems.STRAW_DOLL.get()) continue;
                this.continuousComponent.stopContinuity(entity);
                return;
            }
        }
        if (AbilityHelper.isTargetBlocking(entity, target) || AbilityHelper.isHakiBlocking(entity, target)) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        IEntityStats targetProps = EntityStatsCapability.get(target);
        boolean bl = targetNoHeart = props.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || target.func_70668_bt() == CreatureAttribute.field_223223_b_;
        if (targetProps.hasHeart() && !targetNoHeart) {
            ItemStack heart = new ItemStack((IItemProvider)ModItems.HEART.get());
            SoulboundItemHelper.setOwner(heart, target);
            heart.func_200302_a((ITextComponent)new StringTextComponent(target.func_145748_c_().getString() + "'s Heart"));
            ((PlayerEntity)entity).field_71071_by.func_70441_a(heart);
            targetProps.setHeart(false);
        }
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous() && entity.func_184614_ca().func_190926_b();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }
}

