/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RoomAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "room", new Pair[]{ImmutablePair.of((Object)"Creates a spherical space around the user in which they can manipulate anything or use other skills", null)});
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule.Builder(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE).addApprovedBlocks(ModBlocks.OPE).setBypassGriefRule().build();
    public static final int MIN_ROOM_SIZE = 8;
    public static final int MAX_ROOM_SIZE = 45;
    public static final int MAX_THRESHOLD = 2;
    private static final int CHARGE_TIME = 40;
    private static final int COOLDOWN_MODIFIER = 10;
    private static final float MIN_COOLDOWN = WyHelper.secondsToTicks(1.0f);
    private static final float MAX_COOLDOWN = WyHelper.secondsToTicks(10.0f);
    public static final AbilityCore<RoomAbility> INSTANCE = new AbilityCore.Builder<RoomAbility>("ROOM", AbilityCategory.DEVIL_FRUITS, RoomAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(MIN_COOLDOWN, MAX_COOLDOWN), ChargeComponent.getTooltip(40.0f)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::onChargeTick).addEndEvent(this::onChargeEnd);
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private List<BlockPos> blockList = new ArrayList<BlockPos>();
    private List<BlockPos> placedBlockList = new ArrayList<BlockPos>();
    private int roomSize = 0;
    private BlockPos centerPos;
    private Interval checkPositionInterval = new Interval(20);
    private Interval playSoundInterval = new Interval(18);

    public RoomAbility(AbilityCore<RoomAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.continuousComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.chargeComponent.isCharging()) {
            this.chargeComponent.stopCharging(entity);
        } else if (this.continuousComponent.isContinuous()) {
            this.continuousComponent.stopContinuity(entity);
        } else {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_CREATE_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
            this.chargeComponent.startCharging(entity, 40.0f);
        }
    }

    private void onChargeTick(LivingEntity entity, IAbility ability) {
        if (this.playSoundInterval.canTick()) {
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_CHARGE_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
        }
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.blockList.isEmpty()) {
            this.roomSize = Math.max(8, (int)(45.0f * this.chargeComponent.getChargeTime() / this.chargeComponent.getMaxChargeTime()));
            this.centerPos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            this.blockList.addAll(AbilityHelper.createSphere(entity.field_70170_p, entity.func_233580_cy_(), this.roomSize, true, (Block)ModBlocks.OPE.get(), 0, GRIEF_RULE));
            this.placedBlockList.addAll(this.blockList);
        }
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_EXPAND_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
        this.continuousComponent.startContinuity(entity, -1.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (this.centerPos != null && this.checkPositionInterval.canTick() && !this.isPositionInRoom(entity.func_233580_cy_())) {
            this.continuousComponent.stopContinuity(entity);
        }
        int placedBlocks = 0;
        Iterator<BlockPos> iter = this.placedBlockList.iterator();
        while (iter.hasNext()) {
            BlockPos pos = iter.next();
            entity.field_70170_p.func_184138_a(pos, Blocks.field_150350_a.func_176223_P(), ((Block)ModBlocks.OPE.get()).func_176223_P(), 0);
            iter.remove();
            if (++placedBlocks <= 512) continue;
            return;
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        for (BlockPos pos : this.blockList) {
            Block currentBlock = entity.field_70170_p.func_180495_p(pos).func_177230_c();
            if (currentBlock != ModBlocks.OPE.get()) continue;
            entity.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.centerPos = null;
        this.blockList.clear();
        this.placedBlockList.clear();
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.ROOM_CLOSE_SFX.get(), SoundCategory.PLAYERS, 5.0f, 1.0f);
        float cooldown = WyHelper.secondsToTicks(10 * this.roomSize / 45);
        this.cooldownComponent.startCooldown(entity, cooldown);
    }

    public int getROOMSize() {
        return this.roomSize;
    }

    public BlockPos getCenterBlock() {
        return this.centerPos;
    }

    public boolean isPositionInRoom(BlockPos pos) {
        if (this.centerPos == null) {
            return false;
        }
        return pos.func_218141_a((Vector3i)this.centerPos, (double)this.roomSize);
    }
}

