/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.oto;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "bon", new Pair[]{ImmutablePair.of((Object)"The user plucks a string created from their arm, creating a sound wave that internally damages all who hear it", null)});
    private static final float COOLDOWN = 60.0f;
    private static final float VOLUME = 3.5f;
    private static final int DISTANCE = 24;
    private static final float WIDTH = 3.0f;
    private static final float DAMAGE = 25.0f;
    private static final int ANIMATION_TICKS = 10;
    public static final AbilityCore<BonAbility> INSTANCE = new AbilityCore.Builder<BonAbility>("Bon", AbilityCategory.DEVIL_FRUITS, BonAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f), DealDamageComponent.getTooltip(25.0f), RangeComponent.getTooltip(24.0f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceType(SourceType.INTERNAL).setSourceElement(SourceElement.SHOCKWAVE).build();
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public BonAbility(AbilityCore<BonAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.animationComponent, this.rangeComponent, this.dealDamageComponent);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.BON.get(), SoundCategory.PLAYERS, 3.5f, 0.2f + entity.func_70681_au().nextFloat());
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 24.0f, 3.0f);
        this.animationComponent.start(entity, ModAnimations.BON, 10);
        for (LivingEntity target : targets) {
            if (target.func_70644_a((Effect)ModEffects.SILENT.get())) continue;
            AbilityDamageSource source = (AbilityDamageSource)this.dealDamageComponent.getDamageSource(entity);
            source.setInternal();
            source.setSlash();
            source.markIndirectDamage();
            if (!this.dealDamageComponent.hurtTarget(entity, target, 25.0f, source)) continue;
            Vector3d dist = target.func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72441_c(0.0, -1.0, 0.0).func_72432_b();
            double power = 4.5;
            double xSpeed = -dist.field_72450_a * power;
            double zSpeed = -dist.field_72449_c * power;
            target.func_213293_j(-xSpeed, 0.1, -zSpeed);
            target.field_70133_I = true;
            for (int i = 0; i < 5; ++i) {
                double offsetX = target.func_70681_au().nextDouble() / 2.0;
                double offsetZ = target.func_70681_au().nextDouble() / 2.0;
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197603_N, (ServerWorld)entity.field_70170_p, target.func_226277_ct_() + offsetX, target.func_226278_cu_() + (double)target.func_70047_e() + offsetX, target.func_226281_cx_() + offsetZ);
            }
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197627_t, (ServerWorld)entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
            break;
        }
        this.cooldownComponent.startCooldown(entity, 60.0f);
    }
}

