/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class FlashAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "amaterasu", new Pair[]{ImmutablePair.of((Object)"The user creates a bright flash of light, blinding their opponents. Longer charges means a longer distance.", null)});
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 40;
    private static final int MIN_RANGE = 2;
    private static final int MAX_RANGE = 16;
    public static final AbilityCore<FlashAbility> INSTANCE = new AbilityCore.Builder<FlashAbility>("Flash", AbilityCategory.DEVIL_FRUITS, FlashAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(40.0f), RangeComponent.getTooltip(2.0f, 16.0f, RangeComponent.RangeType.AOE)).setSourceElement(SourceElement.LIGHT).build();
    private final ChargeComponent chargeComponent = new ChargeComponent((IAbility)this, comp -> (double)comp.getChargePercentage() > 0.2).addTickEvent(this::duringChargeEvent).addEndEvent(this::stopChargeEvent);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);

    public FlashAbility(AbilityCore<FlashAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.animationComponent, this.rangeComponent);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity player, IAbility ability) {
        this.chargeComponent.startCharging(player, 40.0f);
    }

    private void duringChargeEvent(LivingEntity player, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.PIKA_CHARGING.get(), (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
    }

    private void stopChargeEvent(LivingEntity player, IAbility ability) {
        AbilityHelper.reduceEffect(player.func_70660_b((Effect)ModEffects.FROZEN.get()), 10.0);
        AbilityHelper.reduceEffect(player.func_70660_b((Effect)ModEffects.FROSTBITE.get()), 10.0);
        AbilityHelper.reduceEffect(player.func_70660_b((Effect)ModEffects.CANDY_STUCK.get()), 10.0);
        AbilityHelper.reduceEffect(player.func_70660_b((Effect)ModEffects.CANDLE_LOCK.get()), 10.0);
        float radius = this.chargeComponent.getChargePercentage() * 16.0f;
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(player, radius);
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 140, 3));
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.FLASH.get(), (Entity)player, target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_());
        }
        this.cooldownComponent.startCooldown(player, 200.0f);
    }
}

