/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RepeaterComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceElement;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.pika.YasakaniNoMagatamaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class YasakaniNoMagatamaAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "yasakani_no_magatama", new Pair[]{ImmutablePair.of((Object)"Fires a torrent of deadly light particles, causing huge destruction", null)});
    private static final int COOLDOWN = 280;
    public static final AbilityCore<YasakaniNoMagatamaAbility> INSTANCE = new AbilityCore.Builder<YasakaniNoMagatamaAbility>("Yasakani no Magatama", AbilityCategory.DEVIL_FRUITS, YasakaniNoMagatamaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(280.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.SPECIAL).setSourceElement(SourceElement.LIGHT).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent);
    private final RepeaterComponent repeaterComponent = new RepeaterComponent(this).addTriggerEvent(this::repeaterTriggerEvent).addStopEvent(this::repeaterStopEvent);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final AnimationComponent animationComponent = new AnimationComponent(this);

    public YasakaniNoMagatamaAbility(AbilityCore<YasakaniNoMagatamaAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.repeaterComponent, this.animationComponent, this.projectileComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.repeaterComponent.stop(entity);
            return;
        }
        this.continuousComponent.triggerContinuity(entity);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.POINT_RIGHT_ARM);
        this.repeaterComponent.start(entity, 25, 3);
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        AbilityHelper.slowEntityFall(entity);
    }

    private void repeaterTriggerEvent(LivingEntity entity, IAbility ability) {
        if (super.canUse(entity).isFail()) {
            this.repeaterComponent.stop(entity);
        }
        this.projectileComponent.shoot(entity, 4.5f, 20.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.PIKA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void repeaterStopEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.stopContinuity(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 280.0f);
    }

    private YasakaniNoMagatamaProjectile createProjectile(LivingEntity entity) {
        YasakaniNoMagatamaProjectile proj = new YasakaniNoMagatamaProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

