/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.rokushiki;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DamageTakenComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class KamieAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "kamie", new Pair[]{ImmutablePair.of((Object)"Makes the user's body scalable in order to avoid attacks", null)});
    private static final float HOLD_TIME = 60.0f;
    private static final float MIN_COOLDOWN = 100.0f;
    private static final float MAX_COOLDOWN = 400.0f;
    public static final AbilityCore<KamieAbility> INSTANCE = new AbilityCore.Builder<KamieAbility>("Kami-E", AbilityCategory.RACIAL, KamieAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(100.0f, 400.0f), ContinuousComponent.getTooltip(60.0f)).setUnlockCheck(KamieAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addEndEvent(100, this::onEndContinuityEvent);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.DODGE_ABILITY, new AbilityPool2[0]);
    private final DamageTakenComponent damageTakenComponent = new DamageTakenComponent(this, this::onDamageTakenEvent, DamageTakenComponent.DamageState.ATTACK);

    public KamieAbility(AbilityCore<KamieAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.poolComponent, this.damageTakenComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 60.0f);
    }

    private void onEndContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.startCooldown(entity, 100.0f + this.continuousComponent.getContinueTime() * 5.0f);
    }

    public float onDamageTakenEvent(LivingEntity entity, IAbility ability, DamageSource damageSource, float damage) {
        if (!super.isContinuous() || !AbilityHelper.canUseMomentumAbilities(entity)) {
            return damage;
        }
        boolean isDamageTaken = true;
        boolean isUnavoidable = damageSource instanceof ModDamageSource && ((ModDamageSource)damageSource).isUnavoidable();
        ArrayList<String> acceptableInstantSources = new ArrayList<String>(Arrays.asList("mob", "player", "ability_projectile", "ability"));
        if ((damageSource.func_76364_f() instanceof LivingEntity || damageSource.func_76364_f() instanceof ProjectileEntity) && acceptableInstantSources.contains(damageSource.func_76355_l()) && !isUnavoidable) {
            isDamageTaken = false;
        }
        if (!isDamageTaken) {
            SoundEvent sfx = (SoundEvent)ModSounds.DODGE_1.get();
            if (entity.func_70681_au().nextBoolean()) {
                sfx = (SoundEvent)ModSounds.DODGE_2.get();
            }
            entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), sfx, SoundCategory.PLAYERS, 1.0f, 0.75f + entity.func_70681_au().nextFloat() / 2.0f);
        }
        return isDamageTaken ? damage : 0.0f;
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        boolean raceCheck = props.isHuman() || DevilFruitCapability.get(user).hasDevilFruit(ModAbilities.HITO_HITO_NO_MI);
        return raceCheck && props.getDoriki() >= 3600.0;
    }
}

