/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.rokushiki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AltModeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class TekkaiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tekkai", new Pair[]{ImmutablePair.of((Object)"Hardens the user's body to protect themselves, but they're unable to move", null), ImmutablePair.of((Object)"  \u00a7aHEAVY\u00a7r immobile, more protection", null), ImmutablePair.of((Object)"  \u00a7aWALK\u00a7r can move, less protection", null)});
    private static final ResourceLocation TEKKAI_WALK_ICON = new ResourceLocation("mineminenomi", "textures/abilities/tekkai_walk.png");
    private static final int CONTINUITY_THRESHOLD = 200;
    private static final int MIN_COOLDOWN = 60;
    private static final int MAX_COOLDOWN = 260;
    public static final AbilityCore<TekkaiAbility> INSTANCE = new AbilityCore.Builder<TekkaiAbility>("Tekkai", AbilityCategory.RACIAL, TekkaiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(60.0f, 260.0f), ContinuousComponent.getTooltip(200.0f)).setUnlockCheck(TekkaiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(100, this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final AltModeComponent<Mode> altModeComponent = new AltModeComponent<Mode>(this, Mode.class, Mode.HEAVY).addChangeModeEvent(this::onAltModeChange);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.TEKKAI_LIKE, new AbilityPool2[0]);

    public TekkaiAbility(AbilityCore<TekkaiAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.altModeComponent, this.animationComponent, this.poolComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 200.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.CROSSED_ARMS);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (this.altModeComponent.isMode(Mode.HEAVY)) {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.GUARDING.get(), 2, 1, false, false));
            entity.func_213293_j(0.0, -5.0, 0.0);
            entity.field_70133_I = true;
        } else {
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.PHYSICAL_MOVING_GUARD.get(), 2, 0, false, false));
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, this.continuousComponent.getContinueTime() + 60.0f);
    }

    private void onAltModeChange(LivingEntity entity, IAbility ability, Mode mode) {
        if (mode == Mode.HEAVY) {
            super.setDisplayIcon(INSTANCE);
        } else if (mode == Mode.WALK) {
            super.setDisplayIcon(TEKKAI_WALK_ICON);
        }
    }

    public void switchToHeavyMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.HEAVY);
    }

    public void switchToWalkMode(LivingEntity entity) {
        this.altModeComponent.setMode(entity, Mode.WALK);
    }

    private static boolean canUnlock(LivingEntity user) {
        IEntityStats props = EntityStatsCapability.get(user);
        boolean raceCheck = props.isHuman() || DevilFruitCapability.get(user).hasDevilFruit(ModAbilities.HITO_HITO_NO_MI);
        return raceCheck && props.getDoriki() >= 1000.0;
    }

    public static enum Mode {
        HEAVY,
        WALK;

    }
}

