/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryupteranodon;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class BeakGrabAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "beak_grab", new Pair[]{ImmutablePair.of((Object)"Allows the user to carry their target.", null)});
    private static final TargetsPredicate TARGET_PREDICATE = new TargetsPredicate().testAdvancedInView();
    private static final int COOLDOWN = 200;
    private static final int HOLD_TIME = 300;
    private static final float RANGE = 1.2f;
    public static final AbilityCore<BeakGrabAbility> INSTANCE = new AbilityCore.Builder<BeakGrabAbility>("Beak Grab", AbilityCategory.DEVIL_FRUITS, BeakGrabAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(300.0f), RangeComponent.getTooltip(1.2f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.HARDENING).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PTERA_FLY.get(), new MorphInfo[0]);
    private final GrabEntityComponent grabEntityComponent = new GrabEntityComponent(this, false, true, 2.0f);

    public BeakGrabAbility(AbilityCore<BeakGrabAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.animationComponent, this.rangeComponent, this.requireMorphComponent, this.grabEntityComponent);
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, 300.0f);
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.animationComponent.start(entity, ModAnimations.PTERA_OPEN_MOUTH);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        LivingEntity grabbedTarget = this.grabEntityComponent.getGrabbedEntity();
        if (super.canUse(entity).isFail() || grabbedTarget != null && !this.grabEntityComponent.canContinueGrab(entity)) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (grabbedTarget == null) {
            this.grabEntityComponent.grabNearest(entity, 1.2f, 1.4f, false);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.grabEntityComponent.release(entity);
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

