/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryupteranodon;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.PropelledFlightAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryupteranodon.BeakGrabAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryupteranodon.PteranodonAssaultPointAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryupteranodon.PteranodonFlyPointAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryupteranodon.TankyudonAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryupteranodon.TempuraudonAbility;
import xyz.pixelatedw.mineminenomi.api.IPlayerAbilities;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;

public class PteranodonFlightAbility
extends PropelledFlightAbility {
    public static final AbilityCore<PteranodonFlightAbility> INSTANCE = new AbilityCore.Builder<PteranodonFlightAbility>("Pteranodon Flight", AbilityCategory.DEVIL_FRUITS, AbilityType.PASSIVE, PteranodonFlightAbility::new).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).build();
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PTERA_ASSAULT.get(), (MorphInfo)ModMorphs.PTERA_FLY.get());

    public PteranodonFlightAbility(AbilityCore<PteranodonFlightAbility> core) {
        super((AbilityCore<? extends PropelledFlightAbility>)core);
        this.addComponents(this.requireMorphComponent);
        super.addDuringPassiveEvent(this::onDuringPassive);
    }

    private void onDuringPassive(LivingEntity entity) {
        boolean isPteranodonFlyPointActive;
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        PteranodonFlyPointAbility pteranodonFlyPointAbility = abilityDataProps.getEquippedAbility(PteranodonFlyPointAbility.INSTANCE);
        double difference = DevilFruitHelper.getDifferenceToFloor((Entity)player);
        boolean bl = isPteranodonFlyPointActive = pteranodonFlyPointAbility != null && pteranodonFlyPointAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous();
        if (isPteranodonFlyPointActive) {
            if (((IPlayerAbilities)player.field_71075_bZ).hasCustomFlight() && !player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = true;
            }
            if (difference < 2.0) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 1.0, 0.0).func_216372_d(1.0, 0.25, 1.0));
            }
        }
    }

    @Override
    public float getMaxSpeed(LivingEntity entity) {
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        PteranodonAssaultPointAbility pteranodonAssaultPointAbility = abilityDataProps.getEquippedAbility(PteranodonAssaultPointAbility.INSTANCE);
        PteranodonFlyPointAbility pteranodonFlyPointAbility = abilityDataProps.getEquippedAbility(PteranodonFlyPointAbility.INSTANCE);
        if (pteranodonAssaultPointAbility != null && pteranodonAssaultPointAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            return entity.func_70051_ag() ? 1.05f : 0.75f;
        }
        if (pteranodonFlyPointAbility != null && pteranodonFlyPointAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            return entity.func_70051_ag() ? 2.1f : 1.5f;
        }
        return 0.0f;
    }

    @Override
    protected float getAcceleration(LivingEntity entity) {
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        PteranodonAssaultPointAbility pteranodonAssaultPointAbility = abilityDataProps.getEquippedAbility(PteranodonAssaultPointAbility.INSTANCE);
        PteranodonFlyPointAbility pteranodonFlyPointAbility = abilityDataProps.getEquippedAbility(PteranodonFlyPointAbility.INSTANCE);
        if (pteranodonAssaultPointAbility != null && pteranodonAssaultPointAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            return entity.func_70051_ag() ? 0.006f : 0.003f;
        }
        if (pteranodonFlyPointAbility != null && pteranodonFlyPointAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            return entity.func_70051_ag() ? 0.012f : 0.006f;
        }
        return 0.0f;
    }

    @Override
    protected int getHeightDifference(LivingEntity entity) {
        return 128;
    }

    @Override
    public float getSpeed(LivingEntity entity) {
        IAbilityData abilityDataProps = AbilityDataCapability.get(entity);
        TempuraudonAbility tempuraudonAbility = abilityDataProps.getEquippedAbility(TempuraudonAbility.INSTANCE);
        TankyudonAbility tankyudonAbility = abilityDataProps.getEquippedAbility(TankyudonAbility.INSTANCE);
        BeakGrabAbility beakGrabAbility = abilityDataProps.getEquippedAbility(BeakGrabAbility.INSTANCE);
        if (tempuraudonAbility != null && tempuraudonAbility.getComponent(ModAbilityKeys.CHARGE).get().isCharging()) {
            return 0.0f;
        }
        if (tankyudonAbility != null && tankyudonAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            entity.field_191988_bg = 0.98f;
            return this.speed += 1.0f;
        }
        if (beakGrabAbility != null && beakGrabAbility.getComponent(ModAbilityKeys.CONTINUOUS).get().isContinuous()) {
            entity.field_191988_bg = 0.98f;
            return this.speed += 1.0f;
        }
        return this.speed;
    }
}

