/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryupteranodon;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TankyudonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tankyudon", new Pair[]{ImmutablePair.of((Object)"Flying into enemies at great speeds deals damage and knocks them back.", null)});
    private static final int COOLDOWN = 200;
    private static final float RANGE = 1.2f;
    private static final double PUSH_FORCE = 2.2;
    private static final float DAMAGE = 10.0f;
    public static final AbilityCore<TankyudonAbility> INSTANCE = new AbilityCore.Builder<TankyudonAbility>("Tankyudon", AbilityCategory.DEVIL_FRUITS, TankyudonAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(), DealDamageComponent.getTooltip(10.0f), RangeComponent.getTooltip(1.2f, RangeComponent.RangeType.LINE)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this).addStartEvent(this::onContinuityStart).addTickEvent(this::onContinuityTick).addEndEvent(this::onContinuityEnd);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PTERA_FLY.get(), new MorphInfo[0]);
    private Interval clearHitsInterval = new Interval(25);

    public TankyudonAbility(AbilityCore<TankyudonAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.continuousComponent, this.dealDamageComponent, this.hitTrackerComponent, this.rangeComponent, this.requireMorphComponent);
        super.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity, WyHelper.secondsToTicks(10.0f));
    }

    private void onContinuityStart(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.hitTrackerComponent.clearHits();
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
    }

    private void onContinuityTick(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (super.canUse(entity).isFail()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        List<LivingEntity> targets = this.rangeComponent.getTargetsInLine(entity, 1.2f, 1.5f);
        if (this.clearHitsInterval.canTick()) {
            this.hitTrackerComponent.clearHits();
        }
        for (LivingEntity target : targets) {
            if (!this.hitTrackerComponent.canHit((Entity)target) || !this.dealDamageComponent.hurtTarget(entity, target, 10.0f)) continue;
            Vector3d pushVec = entity.func_70040_Z().func_178788_d(target.func_70040_Z()).func_72432_b().func_186678_a(2.2);
            target.func_213317_d(pushVec);
        }
    }

    private void onContinuityEnd(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

