/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ryupteranodon;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RequireMorphComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ryupteranodon.TempuraudonProjectile;
import xyz.pixelatedw.mineminenomi.init.ModMorphs;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class TempuraudonAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tempuraudon", new Pair[]{ImmutablePair.of((Object)"Stretches its head back, releasing it really fast and acting as a sniper.", null)});
    private static final int COOLDOWN = 240;
    private static final int CHARGE_TIME = 60;
    public static final AbilityCore<TempuraudonAbility> INSTANCE = new AbilityCore.Builder<TempuraudonAbility>("Tempuraudon", AbilityCategory.DEVIL_FRUITS, TempuraudonAbility::new).addDescriptionLine(DESCRIPTION).addDescriptionLine(AbilityDescriptionLine.NEW_LINE, RequireMorphComponent.getTooltip()).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(240.0f), ChargeComponent.getTooltip(60.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addEndEvent(this::onChargeEnd);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);
    private final RequireMorphComponent requireMorphComponent = new RequireMorphComponent(this, (MorphInfo)ModMorphs.PTERA_ASSAULT.get(), (MorphInfo)ModMorphs.PTERA_FLY.get());

    public TempuraudonAbility(AbilityCore<TempuraudonAbility> core) {
        super(core);
        this.isNew = true;
        super.addComponents(this.chargeComponent, this.projectileComponent, this.requireMorphComponent);
        super.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 60.0f);
    }

    private void onChargeEnd(LivingEntity entity, IAbility ability) {
        this.projectileComponent.shoot(entity, 5.0f, 0.0f);
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DASH_ABILITY_SWOOSH_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        this.cooldownComponent.startCooldown(entity, 240.0f);
    }

    private TempuraudonProjectile createProjectile(LivingEntity entity) {
        TempuraudonProjectile proj = new TempuraudonProjectile(entity.field_70170_p, entity, this);
        return proj;
    }
}

