/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sabi;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RustBreakAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "rust_break", new Pair[]{ImmutablePair.of((Object)"Rusts iron blocks in front of the user", null)});
    private static final float COOLDOWN = 400.0f;
    public static final AbilityCore<RustBreakAbility> INSTANCE = new AbilityCore.Builder<RustBreakAbility>("Rust Break", AbilityCategory.DEVIL_FRUITS, RustBreakAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE).build();

    public RustBreakAbility(AbilityCore<RustBreakAbility> core) {
        super(core);
        this.isNew = true;
        this.addUseEvent(this::onUseEvent);
    }

    private void onUseEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity);
        if (entity.func_195048_a(mop.func_216347_e()) > 50.0) {
            return;
        }
        BlockPos tracePos = new BlockPos(mop.func_216347_e());
        List<BlockPos> rustyBlocks = WyHelper.getNearbyBlocks(tracePos, (IWorld)entity.field_70170_p, 1, p -> entity.field_70170_p.func_180495_p(p).func_177230_c().func_203417_a(ModTags.Blocks.RUSTY), (List<Block>)ImmutableList.of((Object)Blocks.field_150350_a));
        for (BlockPos pos : rustyBlocks) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.RUST_BREAK.get(), (Entity)entity, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            boolean isIngot = this.random.nextBoolean();
            for (int i = 0; i < this.random.nextInt(3); ++i) {
                ItemStack stack = isIngot ? new ItemStack((IItemProvider)Items.field_151042_j) : new ItemStack((IItemProvider)Items.field_191525_da);
                ItemEntity item = new ItemEntity(entity.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                entity.field_70170_p.func_217376_c((Entity)item);
            }
            entity.field_70170_p.func_217377_a(pos, false);
        }
        this.cooldownComponent.startCooldown(entity, 400.0f);
    }
}

