/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sabi;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PunchAbility2;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChangeStatsComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.SkinOverlayComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModTags;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RustTouchAbility
extends PunchAbility2 {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "rust_touch", new Pair[]{ImmutablePair.of((Object)"Rusts the enemy and the items equipped on them", null)});
    private static final float COOLDOWN = 300.0f;
    public static final AbilityCore<RustTouchAbility> INSTANCE = new AbilityCore.Builder<RustTouchAbility>("Rust Touch", AbilityCategory.DEVIL_FRUITS, RustTouchAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(300.0f), ContinuousComponent.getTooltip(), ChangeStatsComponent.getTooltip()).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay.Builder().setTexture(ModResources.RUST_TOUCH_ARM).build();
    private final SkinOverlayComponent skinOverlayComponent = new SkinOverlayComponent(this, OVERLAY, new AbilityOverlay[0]);

    public RustTouchAbility(AbilityCore<RustTouchAbility> core) {
        super((AbilityCore<? extends PunchAbility2>)core);
        this.addComponents(this.skinOverlayComponent);
        this.continuousComponent.addStartEvent(100, this::startContinuityEvent);
        this.continuousComponent.addEndEvent(100, this::endContinuityEvent);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.showAll(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.skinOverlayComponent.hideAll(entity);
    }

    @Override
    public void onHitEffect(LivingEntity entity, LivingEntity target, ModDamageSource source) {
        target.func_195064_c(new EffectInstance(Effects.field_82731_v, 160, 2));
        target.func_195064_c(new EffectInstance(Effects.field_76419_f, 160, 1));
        target.func_195064_c(new EffectInstance(Effects.field_76421_d, 160, 1));
        List<ItemStack> iter = ItemsHelper.getAllInventoryItems(target);
        for (ItemStack stack : iter) {
            if (stack.func_190926_b() || !stack.func_77973_b().func_206844_a(ModTags.Items.RUSTY)) continue;
            if (stack.func_77984_f()) {
                stack.func_222118_a(stack.func_77958_k() / 3 + 1 + 1, target, e -> e.func_213361_c(EquipmentSlotType.MAINHAND));
                continue;
            }
            stack.func_190918_g(1 + this.random.nextInt(4));
        }
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.RUST_TOUCH.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
    }

    @Override
    public Predicate<LivingEntity> canActivate() {
        return entity -> this.continuousComponent.isContinuous();
    }

    @Override
    public int getUseLimit() {
        return 1;
    }

    @Override
    public float getPunchDamage() {
        return 10.0f;
    }

    @Override
    public float getPunchCooldown() {
        return 300.0f;
    }
}

