/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sniper;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BowTriggerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.projectiles.sniper.TetsuBoshiProjectile;
import xyz.pixelatedw.mineminenomi.init.ModQuests;

public class TetsuBoshiAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "tetsu_boshi", new Pair[]{ImmutablePair.of((Object)"Fires a pellet that upon impact releases multiple small iron spikes on the ground", null)});
    private static final float COOLDOWN = 140.0f;
    public static final AbilityCore<TetsuBoshiAbility> INSTANCE = new AbilityCore.Builder<TetsuBoshiAbility>("Tetsu Boshi", AbilityCategory.STYLE, TetsuBoshiAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(140.0f), ContinuousComponent.getTooltip()).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setUnlockCheck(TetsuBoshiAbility::canUnlock).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent(this);
    private final BowTriggerComponent bowTriggerComponent = new BowTriggerComponent(this).addShootEvent(this::shoot);
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public TetsuBoshiAbility(AbilityCore<TetsuBoshiAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent, this.bowTriggerComponent, this.projectileComponent);
        this.addUseEvent(this::onUseEvent);
    }

    public void onUseEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    public boolean shoot(LivingEntity entity, IAbility ability) {
        if (this.continuousComponent.isContinuous()) {
            this.projectileComponent.shoot(entity, 4.0f, 0.5f);
            this.continuousComponent.stopContinuity(entity);
            this.cooldownComponent.startCooldown(entity, 140.0f);
            return true;
        }
        return false;
    }

    public TetsuBoshiProjectile createProjectile(LivingEntity entity) {
        TetsuBoshiProjectile proj = new TetsuBoshiProjectile(entity.field_70170_p, entity);
        return proj;
    }

    private static boolean canUnlock(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        return props.isSniper() && questProps.hasFinishedQuest(ModQuests.SNIPER_TRIAL_03);
    }
}

