/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sui;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.sui.NekomimiPunchAbility;
import xyz.pixelatedw.mineminenomi.abilities.sui.NyanNyanSuplexAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class FreeSwimmingAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "free_swimming", new Pair[]{ImmutablePair.of((Object)"Lets the user swim trough blocks. Swimming is activated by running into a ground block.", null)});
    private static final int COOLDOWN = 20;
    public static final AbilityCore<FreeSwimmingAbility> INSTANCE = new AbilityCore.Builder<FreeSwimmingAbility>("Free Swimming", AbilityCategory.DEVIL_FRUITS, FreeSwimmingAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(20.0f), ContinuousComponent.getTooltip()).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private boolean isSwimming = false;

    public FreeSwimmingAbility(AbilityCore<FreeSwimmingAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuousComponent);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        boolean swimming;
        boolean isNekomimiFresh;
        entity.field_70145_X = true;
        IAbilityData props = AbilityDataCapability.get(entity);
        boolean flying = false;
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            flying = player.field_71075_bZ.field_75100_b;
        }
        BlockPos pos = entity.func_233580_cy_();
        boolean isOnSolidGround = entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)entity.field_70170_p, pos, Direction.UP);
        boolean isMidAir = entity.field_70170_p.func_180495_p(pos.func_177984_a()).func_196958_f() && entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_196958_f();
        boolean groundCheck = entity.func_213303_ch().field_72448_b - DevilFruitHelper.getFloorLevel((Entity)entity).func_82617_b() > 0.0 && entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_196958_f();
        NekomimiPunchAbility nekomimiPunch = props.getEquippedAbility(NekomimiPunchAbility.INSTANCE);
        boolean isNekomimiPunchActive = nekomimiPunch != null && nekomimiPunch.isContinuous();
        boolean bl = isNekomimiFresh = nekomimiPunch != null && entity.field_70170_p.func_82737_E() - nekomimiPunch.getLastUseGametime() < 100L;
        if (!entity.field_70170_p.field_72995_K && entity.func_70090_H()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        boolean isOutsideGround = false;
        if (groundCheck && !isNekomimiPunchActive && !isNekomimiFresh && !this.isEntityInsideOpaqueBlock(entity)) {
            isOutsideGround = true;
        }
        if (isOutsideGround) {
            entity.field_70145_X = false;
            return;
        }
        boolean isInsideBlock = this.isEntityInsideOpaqueBlock(entity);
        if ((isInsideBlock || entity.func_70051_ag()) && !flying) {
            AbilityHelper.setPose(entity, Pose.SWIMMING);
            entity.field_70143_R = 0.0f;
        }
        if (isMidAir && !isNekomimiPunchActive) {
            entity.field_70145_X = true;
            return;
        }
        NyanNyanSuplexAbility nyanSuplex = props.getEquippedAbility(NyanNyanSuplexAbility.INSTANCE);
        if (nyanSuplex != null && nyanSuplex.isCharging()) {
            return;
        }
        entity.func_204711_a(true);
        boolean bl2 = swimming = entity.func_213283_Z() == Pose.SWIMMING || isNekomimiPunchActive;
        if (!entity.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
        if (swimming && (isInsideBlock || isMidAir && isNekomimiPunchActive)) {
            double speed;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double swimSpeed = entity.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e() / 2.0;
            Vector3d lookVector = entity.func_70040_Z();
            if (entity.field_191988_bg != 0.0f) {
                speed = MathHelper.func_151237_a((double)swimSpeed, (double)1.3, (double)6.0);
                x = lookVector.field_72450_a * speed * (double)entity.field_191988_bg;
                y = lookVector.field_72448_b * speed * (double)entity.field_191988_bg;
                z = lookVector.field_72449_c * speed * (double)entity.field_191988_bg;
            }
            if (isNekomimiPunchActive) {
                speed = 1.6;
                x = lookVector.field_72450_a * speed * 1.0;
                y = lookVector.field_72448_b * speed * 1.0;
                z = lookVector.field_72449_c * speed * 1.0;
            }
            if (entity.func_225608_bj_()) {
                y = -0.2f;
            } else if (AbilityHelper.isJumping(entity) && !entity.field_70170_p.func_180495_p(pos.func_177977_b()).func_196958_f()) {
                y = 0.2f;
                if (entity.field_70170_p.func_180495_p(pos.func_177984_a()).func_196958_f()) {
                    y = 0.6f;
                }
            }
            BlockPos frontPos = new BlockPos(entity.func_213303_ch().func_72441_c(x, (double)entity.func_70047_e() + y, z));
            BlockState frontBlock = entity.field_70170_p.func_180495_p(frontPos);
            if (RestrictedBlockProtectionRule.INSTANCE.isBanned(frontBlock)) {
                Vector3d reversedLookVector = lookVector.func_216371_e();
                x = reversedLookVector.field_72450_a;
                y = reversedLookVector.field_72448_b;
                z = reversedLookVector.field_72449_c;
            }
            if (entity.func_226278_cu_() < 5.0) {
                y = 0.0;
            }
            entity.func_213293_j(x, y, z);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.isSwimming = false;
        this.cooldownComponent.startCooldown(entity, 20.0f);
        entity.field_70145_X = false;
    }

    public void setSwimming(boolean flag) {
        this.isSwimming = flag;
    }

    public boolean isSwimming() {
        return this.isSwimming;
    }

    public boolean isEntityInsideOpaqueBlock(LivingEntity entity) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int i = 0; i < 8; ++i) {
            int j = MathHelper.func_76128_c((double)(entity.func_226278_cu_() + (double)(((float)((i >> 0) % 2) - 0.5f) * 0.1f) + (double)entity.func_70047_e()));
            int k = MathHelper.func_76128_c((double)(entity.func_226277_ct_() + (double)(((float)((i >> 1) % 2) - 0.5f) * entity.func_213302_cg() * 0.8f)));
            int l = MathHelper.func_76128_c((double)(entity.func_226281_cx_() + (double)(((float)((i >> 2) % 2) - 0.5f) * entity.func_213311_cf() * 0.8f)));
            if (blockPos.func_177958_n() == k && blockPos.func_177956_o() == j && blockPos.func_177952_p() == l) continue;
            blockPos.func_181079_c(k, j, l);
            boolean isSolid = entity.field_70170_p.func_180495_p((BlockPos)blockPos).func_224755_d((IBlockReader)entity.field_70170_p, (BlockPos)blockPos, Direction.UP);
            if (!isSolid) continue;
            return true;
        }
        return false;
    }
}

