/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sui;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.sui.SuiHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool2;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.GrabEntityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PoolComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAbilityPools;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.CommonExplosionParticleEffect;

public class NyanNyanSuplexAbility
extends Ability {
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "nyan_nyan_suplex", new Pair[]{ImmutablePair.of((Object)"While swimming, grabs the nearest enemy from the back and launches them into the ground, dealing moderate damage and creating a small crater.", null)});
    private static final int COOLDOWN = 200;
    private static final int CHARGE_TIME = 20;
    private static final float RANGE = 1.3f;
    private static final float DAMAGE = 20.0f;
    public static final AbilityCore<NyanNyanSuplexAbility> INSTANCE = new AbilityCore.Builder<NyanNyanSuplexAbility>("Nyan Nyan Suplex", AbilityCategory.DEVIL_FRUITS, NyanNyanSuplexAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ChargeComponent.getTooltip(20.0f), RangeComponent.getTooltip(1.3f, RangeComponent.RangeType.AOE), DealDamageComponent.getTooltip(20.0f)).setSourceHakiNature(SourceHakiNature.HARDENING).setSourceType(SourceType.FIST).build();
    private final ContinuousComponent continuousComponent = new ContinuousComponent((IAbility)this, true).addTickEvent(this::tickContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addTickEvent(this::tickChargingEvent).addEndEvent(this::endChargingEvent);
    private final GrabEntityComponent grabEntityComponent = new GrabEntityComponent(this, true, true, 1.0f);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final PoolComponent poolComponent = new PoolComponent(this, ModAbilityPools.GRAB_ABILITY, new AbilityPool2[0]);

    public NyanNyanSuplexAbility(AbilityCore<NyanNyanSuplexAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.chargeComponent, this.grabEntityComponent, this.continuousComponent, this.rangeComponent, this.dealDamageComponent, this.animationComponent, this.poolComponent);
        this.addCanUseCheck(SuiHelper::isFreeSwimming);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuousComponent.triggerContinuity(entity);
    }

    private void tickContinuityEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (SuiHelper.isFreeSwimming(entity, ability).isFail()) {
            this.continuousComponent.stopContinuity(entity);
            return;
        }
        if (!this.grabEntityComponent.hasGrabbedEntity()) {
            List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.3f);
            for (LivingEntity target : targets) {
                if (!this.grabEntityComponent.grabManually(entity, target)) continue;
                Vector3d lookVec = target.func_70040_Z().func_216371_e().func_216372_d(1.1, 1.0, 1.1);
                Vector3d moveVec = target.func_213303_ch().func_178787_e(lookVec);
                entity.func_70634_a(moveVec.field_72450_a, moveVec.field_72448_b, moveVec.field_72449_c);
                this.animationComponent.start(entity, ModAnimations.POINT_ARMS);
                this.chargeComponent.startCharging(entity, 20.0f);
            }
        }
    }

    private void tickChargingEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!this.grabEntityComponent.canContinueGrab(entity)) {
            this.grabEntityComponent.release(entity);
            this.chargeComponent.stopCharging(entity);
            return;
        }
        LivingEntity target = this.grabEntityComponent.getGrabbedEntity();
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1));
        target.func_195064_c(new EffectInstance((Effect)ModEffects.PARALYSIS.get(), 5, 3));
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        if (this.grabEntityComponent.hasGrabbedEntity()) {
            LivingEntity target = this.grabEntityComponent.getGrabbedEntity();
            this.dealDamageComponent.hurtTarget(entity, target, 20.0f);
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 2.0f);
            explosion.setStaticDamage(30.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.setDamageEntities(true);
            explosion.doExplosion();
            this.grabEntityComponent.release(entity);
        }
        this.continuousComponent.stopContinuity(entity);
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.stop(entity);
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

