/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.init.ModAnimations;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BarjanAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final float DAMAGE_BONUS = 1.25f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "barjan", new Pair[]{ImmutablePair.of((Object)"Dashes forwards hitting all enemies it touches dehydrating them.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(Math.abs(-0.25f) * 100.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 200;
    private static final int HOLD_TIME = 40;
    private static final float DAMAGE = 30.0f;
    private static final float RANGE = 1.6f;
    public static final AbilityCore<BarjanAbility> INSTANCE = new AbilityCore.Builder<BarjanAbility>("Barjan", AbilityCategory.DEVIL_FRUITS, BarjanAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(40.0f), DealDamageComponent.getTooltip(30.0f), RangeComponent.getTooltip(1.6f, RangeComponent.RangeType.AOE)).setSourceHakiNature(SourceHakiNature.IMBUING).build();
    private static final TargetsPredicate TARGETS_PREDICATE = new TargetsPredicate().testEnemyFaction().testAdvancedInView();
    private final ContinuousComponent continuityComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final AnimationComponent animationComponent = new AnimationComponent(this);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);

    public BarjanAbility(AbilityCore<BarjanAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.hitTrackerComponent, this.animationComponent, this.continuityComponent, this.rangeComponent, this.dealDamageComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuityComponent.startContinuity(entity, 40.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.animationComponent.start(entity, ModAnimations.BARJAN, 40);
        Vector3d speed = WyHelper.propulsion(entity, 4.0, 4.0);
        entity.func_213293_j(speed.field_72450_a, (double)0.3f + entity.func_213322_ci().func_82617_b(), speed.field_72449_c);
        entity.field_70133_I = true;
        this.hitTrackerComponent.clearHits();
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.BARJAN.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        List<LivingEntity> targets = this.rangeComponent.getTargetsInArea(entity, 1.6f);
        this.dealDamageComponent.getBonusManager().removeBonus(SunaHelper.DESERT_DAMAGE_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.dealDamageComponent.getBonusManager().addBonus(SunaHelper.DESERT_DAMAGE_BONUS, "Desert Damage Bonus", BonusOperation.MUL, 1.25f);
        }
        float finalDamage = 30.0f * (SunaHelper.isFruitBoosted(entity) ? 1.25f : 1.0f);
        for (LivingEntity target : targets) {
            boolean isHurt;
            if (!this.hitTrackerComponent.canHit((Entity)target) || !(isHurt = this.dealDamageComponent.hurtTarget(entity, target, finalDamage))) continue;
            target.func_195064_c(new EffectInstance((Effect)ModEffects.DEHYDRATION.get(), 200, 2, false, true));
            target.func_195064_c(new EffectInstance(Effects.field_76437_t, 150, 0, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 150, 0, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76419_f, 150, 0, false, false));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

