/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.GroundDeathAbility;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUseResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ChargeComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.RangeComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DesertGirasoleAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final float RANGE_BONUS = 2.0f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "desert_girasole", new Pair[]{ImmutablePair.of((Object)"A giant pit of quicksand will be formed with the sand being taken away by underground rivers.", null), ImmutablePair.of((Object)"Can only be used on sand.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s and range is increased by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(Math.abs(-1.0f) * 100.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 600;
    private static final int CHARGE_TIME = 100;
    private static final int RANGE = 12;
    public static final AbilityCore<DesertGirasoleAbility> INSTANCE = new AbilityCore.Builder<DesertGirasoleAbility>("Desert Girasole", AbilityCategory.DEVIL_FRUITS, DesertGirasoleAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(600.0f), ChargeComponent.getTooltip(100.0f), RangeComponent.getTooltip(12.0f, RangeComponent.RangeType.AOE)).build();
    private final ChargeComponent chargeComponent = new ChargeComponent(this).addStartEvent(this::startChargeEvent).addTickEvent(this::duringChargeEvent).addEndEvent(this::endChargingEvent);
    private final RangeComponent rangeComponent = new RangeComponent(this);
    private BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();

    public DesertGirasoleAbility(AbilityCore<DesertGirasoleAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.rangeComponent, this.chargeComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(DesertGirasoleAbility::requiresInactiveGroundDeath);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.chargeComponent.startCharging(entity, 100.0f);
    }

    private void startChargeEvent(LivingEntity entity, IAbility ability) {
        this.rangeComponent.getBonusManager().removeBonus(SunaHelper.DESERT_RANGE_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.rangeComponent.getBonusManager().addBonus(SunaHelper.DESERT_RANGE_BONUS, "Desert Range Bonus", BonusOperation.MUL, 2.0f);
        }
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (float i = -12.0f; i < 12.0f; i += 1.0f) {
            for (int j = -8; j < 8; ++j) {
                for (float k = -12.0f; k < 12.0f; k += 1.0f) {
                    double posX = entity.func_226277_ct_() + (double)i + ((double)i < -WyHelper.randomWithRange(8, 12) || (double)i > WyHelper.randomWithRange(8, 12) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    double posY = entity.func_226278_cu_() + (double)j;
                    double posZ = entity.func_226281_cx_() + (double)k + ((double)k < -WyHelper.randomWithRange(8, 12) || (double)k > WyHelper.randomWithRange(8, 12) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    mutpos.func_189532_c(posX, posY, posZ);
                    if (!entity.field_70170_p.func_180495_p((BlockPos)mutpos).func_177230_c().equals(Blocks.field_150354_m)) continue;
                    this.blockPlacingHelper.addBlockPos((BlockPos)mutpos, (int)(i * i + (float)(j * j) + k * k));
                }
            }
        }
        if (this.blockPlacingHelper.getBlockList().size() > 0) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DESERT_GIRASOLE_1.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    private void duringChargeEvent(LivingEntity entity, IAbility ability) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.MOVEMENT_BLOCKED.get(), 5, 1, false, false));
        Set<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator<BlockPos> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            if (finished-- < 0) break;
            AbilityHelper.placeBlockIfAllowed(entity, blockPos, ((Block)ModBlocks.SUNA_SAND.get()).func_176223_P(), DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
            iterator.remove();
        }
    }

    private void endChargingEvent(LivingEntity entity, IAbility ability) {
        WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.DESERT_GIRASOLE_2.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 600.0f);
    }

    private static AbilityUseResult requiresInactiveGroundDeath(LivingEntity entity, IAbility ability) {
        GroundDeathAbility groundDeathAbility = AbilityDataCapability.get(entity).getEquippedAbility(GroundDeathAbility.INSTANCE);
        if (groundDeathAbility != null && groundDeathAbility.isCharging()) {
            return AbilityUseResult.fail((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_TOGETHER, new Object[]{ability.getDisplayName().getString(), groundDeathAbility.getDisplayName().getString()}));
        }
        return AbilityUseResult.success();
    }
}

