/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ProjectileComponent;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceHakiNature;
import xyz.pixelatedw.mineminenomi.api.damagesource.SourceType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.DesertSpadaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class DesertSpadaAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final float DAMAGE_BONUS = 1.5f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "desert_spada", new Pair[]{ImmutablePair.of((Object)"The user forms their hand into a blade and stabs it into the ground, creating a sand blade that destroys anything on its path.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s and the damage is increased by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r", "\u00a7a" + Math.round(Math.abs(-0.5f) * 100.0f) + "%\u00a7r"})});
    private static final int COOLDOWN = 160;
    public static final AbilityCore<DesertSpadaAbility> INSTANCE = new AbilityCore.Builder<DesertSpadaAbility>("Desert Spada", AbilityCategory.DEVIL_FRUITS, DesertSpadaAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(160.0f)).addAdvancedDescriptionLine(ProjectileComponent.getProjectileTooltips()).setSourceHakiNature(SourceHakiNature.IMBUING).setSourceType(SourceType.SLASH).build();
    private final ProjectileComponent projectileComponent = new ProjectileComponent(this, this::createProjectile);

    public DesertSpadaAbility(AbilityCore<DesertSpadaAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.projectileComponent);
        this.addCanUseCheck(AbilityHelper::requiresOnGround);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        entity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), (SoundEvent)ModSounds.DESERT_SPADA_SFX.get(), SoundCategory.PLAYERS, 2.0f, 1.0f);
        boolean fruitBoosted = SunaHelper.isFruitBoosted(entity);
        this.projectileComponent.shoot(entity, 3.0f, 1.0f);
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (fruitBoosted) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 160.0f);
    }

    private DesertSpadaProjectile createProjectile(LivingEntity entity) {
        boolean fruitBoosted = SunaHelper.isFruitBoosted(entity);
        this.projectileComponent.getDamageBonusManager().removeBonus(SunaHelper.DESERT_DAMAGE_BONUS);
        if (fruitBoosted) {
            this.projectileComponent.getDamageBonusManager().addBonus(SunaHelper.DESERT_DAMAGE_BONUS, "Desert Damage Bonus", BonusOperation.MUL, 1.5f);
        }
        DesertSpadaProjectile proj = new DesertSpadaProjectile(entity.field_70170_p, entity);
        proj.setMaxLife(fruitBoosted ? 30 : 20);
        return proj;
    }
}

