/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.DealDamageComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.HitTrackerComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GrandeSablesAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "grande_sables", new Pair[]{ImmutablePair.of((Object)"Surrounds the user into a sand tornado, increasing their speed and pulling all nearby entities towards it damaging them.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 200;
    private static final int HOLD_TIME = 50;
    private static final float DAMAGE = 8.0f;
    public static final AbilityCore<GrandeSablesAbility> INSTANCE = new AbilityCore.Builder<GrandeSablesAbility>("Grande Sables", AbilityCategory.DEVIL_FRUITS, GrandeSablesAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(200.0f), ContinuousComponent.getTooltip(50.0f), DealDamageComponent.getTooltip(8.0f)).build();
    private final ContinuousComponent continuityComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private final HitTrackerComponent hitTrackerComponent = new HitTrackerComponent(this);
    private final DealDamageComponent dealDamageComponent = new DealDamageComponent(this);
    private Interval particleInterval = new Interval(15);

    public GrandeSablesAbility(AbilityCore<GrandeSablesAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuityComponent, this.hitTrackerComponent, this.dealDamageComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addCanUseCheck(AbilityHelper::canUseMomentumAbilities);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuityComponent.triggerContinuity(entity, 50.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.hitTrackerComponent.clearHits();
        Vector3d speed = WyHelper.propulsion(entity, 3.0, 3.0);
        entity.func_213293_j(speed.field_72450_a, 2.0, speed.field_72449_c);
        ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)entity));
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.continuityComponent.getContinueTime() < 3.0f) {
            return;
        }
        Vector3d speed = entity.func_70040_Z().func_216372_d(1.2, 1.2, 1.2);
        entity.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        entity.field_70133_I = true;
        entity.func_195064_c(new EffectInstance((Effect)ModEffects.VANISH.get(), 10, 0, false, false));
        if (this.particleInterval.canTick()) {
            WyHelper.spawnParticleEffect((ParticleEffect)ModParticleEffects.SABLES.get(), (Entity)entity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
        float growthXZ = 8.0f;
        float growthY = 20.0f;
        AxisAlignedBB box = new AxisAlignedBB(new BlockPos(entity.func_213303_ch())).func_72314_b((double)growthXZ, (double)growthY, (double)growthXZ);
        for (Entity target : entity.field_70170_p.func_175647_a(Entity.class, box, e -> e != entity)) {
            target.func_213293_j(target.func_213322_ci().field_72450_a + (entity.func_226277_ct_() - target.func_226277_ct_()) / 20.0, target.func_213322_ci().field_72448_b + (entity.func_226278_cu_() - target.func_226278_cu_()) / 20.0, target.func_213322_ci().field_72449_c + (entity.func_226281_cx_() - target.func_226281_cx_()) / 20.0);
            target.field_70133_I = true;
            ModDamageSource source = ModDamageSource.causeAbilityDamage(entity, this, "flyIntoWall").setPiercing(1.0f);
            if (!this.hitTrackerComponent.canHit(target) || !(target instanceof LivingEntity) || !(entity.func_70032_d(target) < 2.0f)) continue;
            this.dealDamageComponent.hurtTarget(entity, (LivingEntity)target, 8.0f, source);
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 200.0f);
    }
}

