/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.abilities.suna.SunaHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.TornadoEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SablesAbility
extends Ability {
    private static final float COOLDOWN_BONUS = 0.8f;
    private static final ITextComponent[] DESCRIPTION = AbilityHelper.registerDescriptionText("mineminenomi", "sables", new Pair[]{ImmutablePair.of((Object)"The user launches a compressed sandstorm at the opponent, which sends them flying.", null), ImmutablePair.of((Object)"While in a desert the cooldown of this ability is reduced by %s.", (Object)new Object[]{"\u00a7a" + Math.round(19.999998f) + "%\u00a7r"})});
    private static final int COOLDOWN = 360;
    private static final int HOLD_TIME = 120;
    public static final AbilityCore<SablesAbility> INSTANCE = new AbilityCore.Builder<SablesAbility>("Sables", AbilityCategory.DEVIL_FRUITS, SablesAbility::new).addDescriptionLine(DESCRIPTION).addAdvancedDescriptionLine(AbilityDescriptionLine.NEW_LINE, CooldownComponent.getTooltip(360.0f), ContinuousComponent.getTooltip(120.0f)).build();
    private final ContinuousComponent continuityComponent = new ContinuousComponent(this).addStartEvent(this::startContinuityEvent).addTickEvent(this::duringContinuityEvent).addEndEvent(this::endContinuityEvent);
    private TornadoEntity proj = null;

    public SablesAbility(AbilityCore<SablesAbility> core) {
        super(core);
        this.isNew = true;
        this.addComponents(this.continuityComponent);
        this.addCanUseCheck(AbilityHelper::requiresDryUser);
        this.addUseEvent(this::useEvent);
    }

    private void useEvent(LivingEntity entity, IAbility ability) {
        this.continuityComponent.triggerContinuity(entity, 120.0f);
    }

    private void startContinuityEvent(LivingEntity entity, IAbility ability) {
        this.proj = null;
    }

    private void duringContinuityEvent(LivingEntity entity, IAbility ability) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)entity, 100.0);
        if (this.proj == null) {
            this.proj = new TornadoEntity(entity.field_70170_p, entity);
            this.proj.setMaxLife(300);
            this.proj.setSize(30.0f);
            this.proj.setSpeed(-2.0f);
            this.proj.func_70107_b(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c);
            entity.field_70170_p.func_217376_c((Entity)this.proj);
        }
        if (!this.proj.func_70089_S() || this.proj == null) {
            this.continuityComponent.stopContinuity(entity);
            return;
        }
        double distance = Math.sqrt(this.proj.func_195048_a(mop.func_216347_e()));
        if (mop.func_216346_c().equals((Object)RayTraceResult.Type.BLOCK) && distance < 100.0) {
            this.proj.setVector(mop.func_216347_e().func_72441_c(0.0, 10.0, 0.0));
        }
    }

    private void endContinuityEvent(LivingEntity entity, IAbility ability) {
        if (this.proj != null && this.proj.func_70089_S()) {
            this.proj.func_70106_y();
        }
        this.cooldownComponent.getBonusManager().removeBonus(SunaHelper.DESERT_COOLDOWN_BONUS);
        if (SunaHelper.isFruitBoosted(entity)) {
            this.cooldownComponent.getBonusManager().addBonus(SunaHelper.DESERT_COOLDOWN_BONUS, "Desert Cooldown Bonus", BonusOperation.MUL, 0.8f);
        }
        this.cooldownComponent.startCooldown(entity, 360.0f);
    }
}

